// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
 */
@Fluent
public final class ProfileLogScrubbing {
    /*
     * State of the log scrubbing config. Default value is Enabled.
     */
    @JsonProperty(value = "state")
    private ProfileScrubbingState state;

    /*
     * List of log scrubbing rules applied to the Azure Front Door profile logs.
     */
    @JsonProperty(value = "scrubbingRules")
    private List<ProfileScrubbingRules> scrubbingRules;

    /**
     * Creates an instance of ProfileLogScrubbing class.
     */
    public ProfileLogScrubbing() {
    }

    /**
     * Get the state property: State of the log scrubbing config. Default value is Enabled.
     * 
     * @return the state value.
     */
    public ProfileScrubbingState state() {
        return this.state;
    }

    /**
     * Set the state property: State of the log scrubbing config. Default value is Enabled.
     * 
     * @param state the state value to set.
     * @return the ProfileLogScrubbing object itself.
     */
    public ProfileLogScrubbing withState(ProfileScrubbingState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the scrubbingRules property: List of log scrubbing rules applied to the Azure Front Door profile logs.
     * 
     * @return the scrubbingRules value.
     */
    public List<ProfileScrubbingRules> scrubbingRules() {
        return this.scrubbingRules;
    }

    /**
     * Set the scrubbingRules property: List of log scrubbing rules applied to the Azure Front Door profile logs.
     * 
     * @param scrubbingRules the scrubbingRules value to set.
     * @return the ProfileLogScrubbing object itself.
     */
    public ProfileLogScrubbing withScrubbingRules(List<ProfileScrubbingRules> scrubbingRules) {
        this.scrubbingRules = scrubbingRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scrubbingRules() != null) {
            scrubbingRules().forEach(e -> e.validate());
        }
    }
}
