// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Defines the common attributes for a custom rule that can be included in a waf policy.
 */
@Fluent
public class CustomRule {
    /*
     * Defines the name of the custom rule
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JsonProperty(value = "enabledState")
    private CustomRuleEnabledState enabledState;

    /*
     * Defines in what order this rule be evaluated in the overall list of custom rules
     */
    @JsonProperty(value = "priority", required = true)
    private int priority;

    /*
     * List of match conditions.
     */
    @JsonProperty(value = "matchConditions", required = true)
    private List<MatchCondition> matchConditions;

    /*
     * Describes what action to be applied when rule matches
     */
    @JsonProperty(value = "action", required = true)
    private ActionType action;

    /**
     * Creates an instance of CustomRule class.
     */
    public CustomRule() {
    }

    /**
     * Get the name property: Defines the name of the custom rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Defines the name of the custom rule.
     * 
     * @param name the name value to set.
     * @return the CustomRule object itself.
     */
    public CustomRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the enabledState property: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled
     * if not specified.
     * 
     * @return the enabledState value.
     */
    public CustomRuleEnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set the enabledState property: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled
     * if not specified.
     * 
     * @param enabledState the enabledState value to set.
     * @return the CustomRule object itself.
     */
    public CustomRule withEnabledState(CustomRuleEnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Get the priority property: Defines in what order this rule be evaluated in the overall list of custom rules.
     * 
     * @return the priority value.
     */
    public int priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Defines in what order this rule be evaluated in the overall list of custom rules.
     * 
     * @param priority the priority value to set.
     * @return the CustomRule object itself.
     */
    public CustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the matchConditions property: List of match conditions.
     * 
     * @return the matchConditions value.
     */
    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    /**
     * Set the matchConditions property: List of match conditions.
     * 
     * @param matchConditions the matchConditions value to set.
     * @return the CustomRule object itself.
     */
    public CustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    /**
     * Get the action property: Describes what action to be applied when rule matches.
     * 
     * @return the action value.
     */
    public ActionType action() {
        return this.action;
    }

    /**
     * Set the action property: Describes what action to be applied when rule matches.
     * 
     * @param action the action value to set.
     * @return the CustomRule object itself.
     */
    public CustomRule withAction(ActionType action) {
        this.action = action;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property name in model CustomRule"));
        }
        if (matchConditions() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property matchConditions in model CustomRule"));
        } else {
            matchConditions().forEach(e -> e.validate());
        }
        if (action() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property action in model CustomRule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomRule.class);
}
