// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Reference to another resource along with its state.
 */
@Fluent
public final class ActivatedResourceReference {
    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * Whether the resource is active or inactive
     */
    @JsonProperty(value = "isActive", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isActive;

    /**
     * Creates an instance of ActivatedResourceReference class.
     */
    public ActivatedResourceReference() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the ActivatedResourceReference object itself.
     */
    public ActivatedResourceReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the isActive property: Whether the resource is active or inactive.
     * 
     * @return the isActive value.
     */
    public Boolean isActive() {
        return this.isActive;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
