/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.AfdDomainUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.DomainValidationProperties;
import com.azure.resourcemanager.cdn.models.DomainValidationState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class AfdDomainProperties
extends AfdDomainUpdatePropertiesParameters {
    @JsonProperty(value="domainValidationState", access=JsonProperty.Access.WRITE_ONLY)
    private DomainValidationState domainValidationState;
    @JsonProperty(value="hostName", required=true)
    private String hostname;
    @JsonProperty(value="extendedProperties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> extendedProperties;
    @JsonProperty(value="validationProperties", access=JsonProperty.Access.WRITE_ONLY)
    private DomainValidationProperties validationProperties;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    private static final ClientLogger LOGGER = new ClientLogger(AfdDomainProperties.class);

    public DomainValidationState domainValidationState() {
        return this.domainValidationState;
    }

    public String hostname() {
        return this.hostname;
    }

    public AfdDomainProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    public AfdDomainProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public DomainValidationProperties validationProperties() {
        return this.validationProperties;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public AfdDomainProperties withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        super.withTlsSettings(tlsSettings);
        return this;
    }

    @Override
    public AfdDomainProperties withAzureDnsZone(ResourceReference azureDnsZone) {
        super.withAzureDnsZone(azureDnsZone);
        return this;
    }

    @Override
    public AfdDomainProperties withPreValidatedCustomDomainResourceId(ResourceReference preValidatedCustomDomainResourceId) {
        super.withPreValidatedCustomDomainResourceId(preValidatedCustomDomainResourceId);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.hostname() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property hostname in model AfdDomainProperties"));
        }
        if (this.validationProperties() != null) {
            this.validationProperties().validate();
        }
    }
}

