// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.fluent.models.ResourceUsageInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Output of check resource usage API.
 */
@Fluent
public final class ResourceUsageListResult {
    /*
     * List of resource usages.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<ResourceUsageInner> value;

    /*
     * URL to get the next set of custom domain objects if there are any.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of ResourceUsageListResult class.
     */
    public ResourceUsageListResult() {
    }

    /**
     * Get the value property: List of resource usages.
     * 
     * @return the value value.
     */
    public List<ResourceUsageInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of custom domain objects if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of custom domain objects if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceUsageListResult object itself.
     */
    public ResourceUsageListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
