// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Defines CDN web application firewall policy properties.
 */
@Fluent
public final class CdnWebApplicationFirewallPolicyProperties {
    /*
     * Describes policySettings for policy
     */
    @JsonProperty(value = "policySettings")
    private PolicySettings policySettings;

    /*
     * Describes rate limit rules inside the policy.
     */
    @JsonProperty(value = "rateLimitRules")
    private RateLimitRuleList rateLimitRules;

    /*
     * Describes custom rules inside the policy.
     */
    @JsonProperty(value = "customRules")
    private CustomRuleList customRules;

    /*
     * Describes managed rules inside the policy.
     */
    @JsonProperty(value = "managedRules")
    private ManagedRuleSetList managedRules;

    /*
     * Describes Azure CDN endpoints associated with this Web Application Firewall policy.
     */
    @JsonProperty(value = "endpointLinks", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointResource> endpointLinks;

    /*
     * Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    @JsonProperty(value = "extendedProperties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> extendedProperties;

    /*
     * Provisioning state of the WebApplicationFirewallPolicy.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Resource status of the policy.
     */
    @JsonProperty(value = "resourceState", access = JsonProperty.Access.WRITE_ONLY)
    private PolicyResourceState resourceState;

    /**
     * Creates an instance of CdnWebApplicationFirewallPolicyProperties class.
     */
    public CdnWebApplicationFirewallPolicyProperties() {
    }

    /**
     * Get the policySettings property: Describes policySettings for policy.
     * 
     * @return the policySettings value.
     */
    public PolicySettings policySettings() {
        return this.policySettings;
    }

    /**
     * Set the policySettings property: Describes policySettings for policy.
     * 
     * @param policySettings the policySettings value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    /**
     * Get the rateLimitRules property: Describes rate limit rules inside the policy.
     * 
     * @return the rateLimitRules value.
     */
    public RateLimitRuleList rateLimitRules() {
        return this.rateLimitRules;
    }

    /**
     * Set the rateLimitRules property: Describes rate limit rules inside the policy.
     * 
     * @param rateLimitRules the rateLimitRules value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withRateLimitRules(RateLimitRuleList rateLimitRules) {
        this.rateLimitRules = rateLimitRules;
        return this;
    }

    /**
     * Get the customRules property: Describes custom rules inside the policy.
     * 
     * @return the customRules value.
     */
    public CustomRuleList customRules() {
        return this.customRules;
    }

    /**
     * Set the customRules property: Describes custom rules inside the policy.
     * 
     * @param customRules the customRules value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    /**
     * Get the managedRules property: Describes managed rules inside the policy.
     * 
     * @return the managedRules value.
     */
    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    /**
     * Set the managedRules property: Describes managed rules inside the policy.
     * 
     * @param managedRules the managedRules value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    /**
     * Get the endpointLinks property: Describes Azure CDN endpoints associated with this Web Application Firewall
     * policy.
     * 
     * @return the endpointLinks value.
     */
    public List<EndpointResource> endpointLinks() {
        return this.endpointLinks;
    }

    /**
     * Get the extendedProperties property: Key-Value pair representing additional properties for Web Application
     * Firewall policy.
     * 
     * @return the extendedProperties value.
     */
    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    /**
     * Set the extendedProperties property: Key-Value pair representing additional properties for Web Application
     * Firewall policy.
     * 
     * @param extendedProperties the extendedProperties value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the WebApplicationFirewallPolicy.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceState property: Resource status of the policy.
     * 
     * @return the resourceState value.
     */
    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policySettings() != null) {
            policySettings().validate();
        }
        if (rateLimitRules() != null) {
            rateLimitRules().validate();
        }
        if (customRules() != null) {
            customRules().validate();
        }
        if (managedRules() != null) {
            managedRules().validate();
        }
        if (endpointLinks() != null) {
            endpointLinks().forEach(e -> e.validate());
        }
    }
}
