// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.fluent.models.SecurityPolicyUpdateProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The JSON object containing security policy update parameters. */
@Fluent
public final class SecurityPolicyUpdateParameters {
    /*
     * The json object that contains properties required to update a security policy
     */
    @JsonProperty(value = "properties")
    private SecurityPolicyUpdateProperties innerProperties;

    /** Creates an instance of SecurityPolicyUpdateParameters class. */
    public SecurityPolicyUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The json object that contains properties required to update a security policy.
     *
     * @return the innerProperties value.
     */
    private SecurityPolicyUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the parameters property: object which contains security policy parameters.
     *
     * @return the parameters value.
     */
    public SecurityPolicyPropertiesParameters parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: object which contains security policy parameters.
     *
     * @param parameters the parameters value to set.
     * @return the SecurityPolicyUpdateParameters object itself.
     */
    public SecurityPolicyUpdateParameters withParameters(SecurityPolicyPropertiesParameters parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityPolicyUpdateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
