// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainResourceState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningSubstate;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g.
 * www.contoso.com.
 */
@Fluent
public final class CustomDomainInner extends ProxyResource {
    /*
     * The JSON object that contains the properties of the custom domain to create.
     */
    @JsonProperty(value = "properties")
    private CustomDomainProperties innerProperties;

    /** Creates an instance of CustomDomainInner class. */
    public CustomDomainInner() {
    }

    /**
     * Get the innerProperties property: The JSON object that contains the properties of the custom domain to create.
     *
     * @return the innerProperties value.
     */
    private CustomDomainProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the hostname property: The host name of the custom domain. Must be a domain name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: The host name of the custom domain. Must be a domain name.
     *
     * @param hostname the hostname value to set.
     * @return the CustomDomainInner object itself.
     */
    public CustomDomainInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Get the resourceState property: Resource status of the custom domain.
     *
     * @return the resourceState value.
     */
    public CustomDomainResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    /**
     * Get the customHttpsProvisioningState property: Provisioning status of the custom domain.
     *
     * @return the customHttpsProvisioningState value.
     */
    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsProvisioningState();
    }

    /**
     * Get the customHttpsProvisioningSubstate property: Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step.
     *
     * @return the customHttpsProvisioningSubstate value.
     */
    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsProvisioningSubstate();
    }

    /**
     * Get the customHttpsParameters property: Certificate parameters for securing custom HTTPS.
     *
     * @return the customHttpsParameters value.
     */
    public CustomDomainHttpsParameters customHttpsParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsParameters();
    }

    /**
     * Set the customHttpsParameters property: Certificate parameters for securing custom HTTPS.
     *
     * @param customHttpsParameters the customHttpsParameters value to set.
     * @return the CustomDomainInner object itself.
     */
    public CustomDomainInner withCustomHttpsParameters(CustomDomainHttpsParameters customHttpsParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainProperties();
        }
        this.innerProperties().withCustomHttpsParameters(customHttpsParameters);
        return this;
    }

    /**
     * Get the validationData property: Special validation or data may be required when delivering CDN to some regions
     * due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in
     * China.
     *
     * @return the validationData value.
     */
    public String validationData() {
        return this.innerProperties() == null ? null : this.innerProperties().validationData();
    }

    /**
     * Set the validationData property: Special validation or data may be required when delivering CDN to some regions
     * due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in
     * China.
     *
     * @param validationData the validationData value to set.
     * @return the CustomDomainInner object itself.
     */
    public CustomDomainInner withValidationData(String validationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainProperties();
        }
        this.innerProperties().withValidationData(validationData);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning status of Custom Https of the custom domain.
     *
     * @return the provisioningState value.
     */
    public CustomHttpsProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
