// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The JSON object that represents the range for http status codes. */
@Fluent
public final class HttpErrorRangeParameters {
    /*
     * The inclusive start of the http status code range.
     */
    @JsonProperty(value = "begin")
    private Integer begin;

    /*
     * The inclusive end of the http status code range.
     */
    @JsonProperty(value = "end")
    private Integer end;

    /** Creates an instance of HttpErrorRangeParameters class. */
    public HttpErrorRangeParameters() {
    }

    /**
     * Get the begin property: The inclusive start of the http status code range.
     *
     * @return the begin value.
     */
    public Integer begin() {
        return this.begin;
    }

    /**
     * Set the begin property: The inclusive start of the http status code range.
     *
     * @param begin the begin value to set.
     * @return the HttpErrorRangeParameters object itself.
     */
    public HttpErrorRangeParameters withBegin(Integer begin) {
        this.begin = begin;
        return this;
    }

    /**
     * Get the end property: The inclusive end of the http status code range.
     *
     * @return the end value.
     */
    public Integer end() {
        return this.end;
    }

    /**
     * Set the end property: The inclusive end of the http status code range.
     *
     * @param end the end value to set.
     * @return the HttpErrorRangeParameters object itself.
     */
    public HttpErrorRangeParameters withEnd(Integer end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
