// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin. */
@Fluent
public final class SharedPrivateLinkResourceProperties {
    /*
     * The resource id of the resource the shared private link resource is for.
     */
    @JsonProperty(value = "privateLink")
    private ResourceReference privateLink;

    /*
     * The location of the shared private link resource
     */
    @JsonProperty(value = "privateLinkLocation")
    private String privateLinkLocation;

    /*
     * The group id from the provider of resource the shared private link resource is for.
     */
    @JsonProperty(value = "groupId")
    private String groupId;

    /*
     * The request message for requesting approval of the shared private link resource.
     */
    @JsonProperty(value = "requestMessage")
    private String requestMessage;

    /*
     * Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
     */
    @JsonProperty(value = "status")
    private SharedPrivateLinkResourceStatus status;

    /** Creates an instance of SharedPrivateLinkResourceProperties class. */
    public SharedPrivateLinkResourceProperties() {
    }

    /**
     * Get the privateLink property: The resource id of the resource the shared private link resource is for.
     *
     * @return the privateLink value.
     */
    public ResourceReference privateLink() {
        return this.privateLink;
    }

    /**
     * Set the privateLink property: The resource id of the resource the shared private link resource is for.
     *
     * @param privateLink the privateLink value to set.
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withPrivateLink(ResourceReference privateLink) {
        this.privateLink = privateLink;
        return this;
    }

    /**
     * Get the privateLinkLocation property: The location of the shared private link resource.
     *
     * @return the privateLinkLocation value.
     */
    public String privateLinkLocation() {
        return this.privateLinkLocation;
    }

    /**
     * Set the privateLinkLocation property: The location of the shared private link resource.
     *
     * @param privateLinkLocation the privateLinkLocation value to set.
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withPrivateLinkLocation(String privateLinkLocation) {
        this.privateLinkLocation = privateLinkLocation;
        return this;
    }

    /**
     * Get the groupId property: The group id from the provider of resource the shared private link resource is for.
     *
     * @return the groupId value.
     */
    public String groupId() {
        return this.groupId;
    }

    /**
     * Set the groupId property: The group id from the provider of resource the shared private link resource is for.
     *
     * @param groupId the groupId value to set.
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
     * Get the requestMessage property: The request message for requesting approval of the shared private link resource.
     *
     * @return the requestMessage value.
     */
    public String requestMessage() {
        return this.requestMessage;
    }

    /**
     * Set the requestMessage property: The request message for requesting approval of the shared private link resource.
     *
     * @param requestMessage the requestMessage value to set.
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    /**
     * Get the status property: Status of the shared private link resource. Can be Pending, Approved, Rejected,
     * Disconnected, or Timeout.
     *
     * @return the status value.
     */
    public SharedPrivateLinkResourceStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the shared private link resource. Can be Pending, Approved, Rejected,
     * Disconnected, or Timeout.
     *
     * @param status the status value to set.
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withStatus(SharedPrivateLinkResourceStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateLink() != null) {
            privateLink().validate();
        }
    }
}
