// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Defines a rate limiting rule that can be included in a waf policy. */
@Fluent
public final class RateLimitRule extends CustomRule {
    /*
     * Defines rate limit threshold.
     */
    @JsonProperty(value = "rateLimitThreshold", required = true)
    private int rateLimitThreshold;

    /*
     * Defines rate limit duration. Default is 1 minute.
     */
    @JsonProperty(value = "rateLimitDurationInMinutes", required = true)
    private int rateLimitDurationInMinutes;

    /** Creates an instance of RateLimitRule class. */
    public RateLimitRule() {
    }

    /**
     * Get the rateLimitThreshold property: Defines rate limit threshold.
     *
     * @return the rateLimitThreshold value.
     */
    public int rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    /**
     * Set the rateLimitThreshold property: Defines rate limit threshold.
     *
     * @param rateLimitThreshold the rateLimitThreshold value to set.
     * @return the RateLimitRule object itself.
     */
    public RateLimitRule withRateLimitThreshold(int rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    /**
     * Get the rateLimitDurationInMinutes property: Defines rate limit duration. Default is 1 minute.
     *
     * @return the rateLimitDurationInMinutes value.
     */
    public int rateLimitDurationInMinutes() {
        return this.rateLimitDurationInMinutes;
    }

    /**
     * Set the rateLimitDurationInMinutes property: Defines rate limit duration. Default is 1 minute.
     *
     * @param rateLimitDurationInMinutes the rateLimitDurationInMinutes value to set.
     * @return the RateLimitRule object itself.
     */
    public RateLimitRule withRateLimitDurationInMinutes(int rateLimitDurationInMinutes) {
        this.rateLimitDurationInMinutes = rateLimitDurationInMinutes;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RateLimitRule withName(String name) {
        super.withName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RateLimitRule withEnabledState(CustomRuleEnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RateLimitRule withPriority(int priority) {
        super.withPriority(priority);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RateLimitRule withMatchConditions(List<MatchCondition> matchConditions) {
        super.withMatchConditions(matchConditions);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RateLimitRule withAction(ActionType action) {
        super.withAction(action);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
