// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.models.CanMigrateDefaultSku;
import com.azure.resourcemanager.cdn.models.MigrationErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The CanMigrateProperties model. */
@Fluent
public final class CanMigrateProperties {
    /*
     * Flag that says if the profile can be migrated
     */
    @JsonProperty(value = "canMigrate", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean canMigrate;

    /*
     * Recommended sku for the migration
     */
    @JsonProperty(value = "defaultSku", access = JsonProperty.Access.WRITE_ONLY)
    private CanMigrateDefaultSku defaultSku;

    /*
     * The errors property.
     */
    @JsonProperty(value = "errors")
    private List<MigrationErrorType> errors;

    /** Creates an instance of CanMigrateProperties class. */
    public CanMigrateProperties() {
    }

    /**
     * Get the canMigrate property: Flag that says if the profile can be migrated.
     *
     * @return the canMigrate value.
     */
    public Boolean canMigrate() {
        return this.canMigrate;
    }

    /**
     * Get the defaultSku property: Recommended sku for the migration.
     *
     * @return the defaultSku value.
     */
    public CanMigrateDefaultSku defaultSku() {
        return this.defaultSku;
    }

    /**
     * Get the errors property: The errors property.
     *
     * @return the errors value.
     */
    public List<MigrationErrorType> errors() {
        return this.errors;
    }

    /**
     * Set the errors property: The errors property.
     *
     * @param errors the errors value to set.
     * @return the CanMigrateProperties object itself.
     */
    public CanMigrateProperties withErrors(List<MigrationErrorType> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
    }
}
