/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.MigrationWebApplicationFirewallMapping;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class MigrationParameters {
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="classicResourceReference", required=true)
    private ResourceReference classicResourceReference;
    @JsonProperty(value="profileName", required=true)
    private String profileName;
    @JsonProperty(value="migrationWebApplicationFirewallMappings")
    private List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings;
    private static final ClientLogger LOGGER = new ClientLogger(MigrationParameters.class);

    public Sku sku() {
        return this.sku;
    }

    public MigrationParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public ResourceReference classicResourceReference() {
        return this.classicResourceReference;
    }

    public MigrationParameters withClassicResourceReference(ResourceReference classicResourceReference) {
        this.classicResourceReference = classicResourceReference;
        return this;
    }

    public String profileName() {
        return this.profileName;
    }

    public MigrationParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings() {
        return this.migrationWebApplicationFirewallMappings;
    }

    public MigrationParameters withMigrationWebApplicationFirewallMappings(List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings) {
        this.migrationWebApplicationFirewallMappings = migrationWebApplicationFirewallMappings;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model MigrationParameters"));
        }
        this.sku().validate();
        if (this.classicResourceReference() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property classicResourceReference in model MigrationParameters"));
        }
        this.classicResourceReference().validate();
        if (this.profileName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property profileName in model MigrationParameters"));
        }
        if (this.migrationWebApplicationFirewallMappings() != null) {
            this.migrationWebApplicationFirewallMappings().forEach(e -> e.validate());
        }
    }
}

