// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Defines how to identify a parameter for a specific purpose e.g. expires. */
@Fluent
public final class UrlSigningParamIdentifier {
    /*
     * Indicates the purpose of the parameter
     */
    @JsonProperty(value = "paramIndicator", required = true)
    private ParamIndicator paramIndicator;

    /*
     * Parameter name
     */
    @JsonProperty(value = "paramName", required = true)
    private String paramName;

    /**
     * Get the paramIndicator property: Indicates the purpose of the parameter.
     *
     * @return the paramIndicator value.
     */
    public ParamIndicator paramIndicator() {
        return this.paramIndicator;
    }

    /**
     * Set the paramIndicator property: Indicates the purpose of the parameter.
     *
     * @param paramIndicator the paramIndicator value to set.
     * @return the UrlSigningParamIdentifier object itself.
     */
    public UrlSigningParamIdentifier withParamIndicator(ParamIndicator paramIndicator) {
        this.paramIndicator = paramIndicator;
        return this;
    }

    /**
     * Get the paramName property: Parameter name.
     *
     * @return the paramName value.
     */
    public String paramName() {
        return this.paramName;
    }

    /**
     * Set the paramName property: Parameter name.
     *
     * @param paramName the paramName value to set.
     * @return the UrlSigningParamIdentifier object itself.
     */
    public UrlSigningParamIdentifier withParamName(String paramName) {
        this.paramName = paramName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (paramIndicator() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property paramIndicator in model UrlSigningParamIdentifier"));
        }
        if (paramName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property paramName in model UrlSigningParamIdentifier"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningParamIdentifier.class);
}
