// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.LoadBalancingSettingsParameters;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from
 * CDN.
 */
@Fluent
public final class AfdOriginGroupInner extends ProxyResource {
    /*
     * The JSON object that contains the properties of the origin group.
     */
    @JsonProperty(value = "properties")
    private AfdOriginGroupProperties innerProperties;

    /*
     * Read only system data
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: The JSON object that contains the properties of the origin group.
     *
     * @return the innerProperties value.
     */
    private AfdOriginGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Read only system data.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the provisioningState property: Provisioning status.
     *
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     *
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    /**
     * Get the profileName property: The name of the profile which holds the origin group.
     *
     * @return the profileName value.
     */
    public String profileName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileName();
    }

    /**
     * Get the loadBalancingSettings property: Load balancing settings for a backend pool.
     *
     * @return the loadBalancingSettings value.
     */
    public LoadBalancingSettingsParameters loadBalancingSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingSettings();
    }

    /**
     * Set the loadBalancingSettings property: Load balancing settings for a backend pool.
     *
     * @param loadBalancingSettings the loadBalancingSettings value to set.
     * @return the AfdOriginGroupInner object itself.
     */
    public AfdOriginGroupInner withLoadBalancingSettings(LoadBalancingSettingsParameters loadBalancingSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    /**
     * Get the healthProbeSettings property: Health probe settings to the origin that is used to determine the health of
     * the origin.
     *
     * @return the healthProbeSettings value.
     */
    public HealthProbeParameters healthProbeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().healthProbeSettings();
    }

    /**
     * Set the healthProbeSettings property: Health probe settings to the origin that is used to determine the health of
     * the origin.
     *
     * @param healthProbeSettings the healthProbeSettings value to set.
     * @return the AfdOriginGroupInner object itself.
     */
    public AfdOriginGroupInner withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    /**
     * Get the trafficRestorationTimeToHealedOrNewEndpointsInMinutes property: Time in minutes to shift the traffic to
     * the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins.
     * This property is currently not supported.
     *
     * @return the trafficRestorationTimeToHealedOrNewEndpointsInMinutes value.
     */
    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.innerProperties() == null
            ? null
            : this.innerProperties().trafficRestorationTimeToHealedOrNewEndpointsInMinutes();
    }

    /**
     * Set the trafficRestorationTimeToHealedOrNewEndpointsInMinutes property: Time in minutes to shift the traffic to
     * the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins.
     * This property is currently not supported.
     *
     * @param trafficRestorationTimeToHealedOrNewEndpointsInMinutes the
     *     trafficRestorationTimeToHealedOrNewEndpointsInMinutes value to set.
     * @return the AfdOriginGroupInner object itself.
     */
    public AfdOriginGroupInner withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(
        Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this
            .innerProperties()
            .withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(
                trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        return this;
    }

    /**
     * Get the sessionAffinityState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     *
     * @return the sessionAffinityState value.
     */
    public EnabledState sessionAffinityState() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionAffinityState();
    }

    /**
     * Set the sessionAffinityState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     *
     * @param sessionAffinityState the sessionAffinityState value to set.
     * @return the AfdOriginGroupInner object itself.
     */
    public AfdOriginGroupInner withSessionAffinityState(EnabledState sessionAffinityState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withSessionAffinityState(sessionAffinityState);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
