/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import com.azure.resourcemanager.cdn.models.SecurityPolicyWebApplicationFirewallAssociation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="WebApplicationFirewall")
public final class SecurityPolicyWebApplicationFirewallParameters
extends SecurityPolicyPropertiesParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SecurityPolicyWebApplicationFirewallParameters.class);
    @JsonProperty(value="wafPolicy")
    private ResourceReference wafPolicy;
    @JsonProperty(value="associations")
    private List<SecurityPolicyWebApplicationFirewallAssociation> associations;

    public ResourceReference wafPolicy() {
        return this.wafPolicy;
    }

    public SecurityPolicyWebApplicationFirewallParameters withWafPolicy(ResourceReference wafPolicy) {
        this.wafPolicy = wafPolicy;
        return this;
    }

    public List<SecurityPolicyWebApplicationFirewallAssociation> associations() {
        return this.associations;
    }

    public SecurityPolicyWebApplicationFirewallParameters withAssociations(List<SecurityPolicyWebApplicationFirewallAssociation> associations) {
        this.associations = associations;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.wafPolicy() != null) {
            this.wafPolicy().validate();
        }
        if (this.associations() != null) {
            this.associations().forEach(e -> e.validate());
        }
    }
}

