/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.EndpointPropertiesUpdateParameters;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class EndpointUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EndpointUpdateParameters.class);
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties")
    private EndpointPropertiesUpdateParameters innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public EndpointUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private EndpointPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public String originPath() {
        return this.innerProperties() == null ? null : this.innerProperties().originPath();
    }

    public EndpointUpdateParameters withOriginPath(String originPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withOriginPath(originPath);
        return this;
    }

    public List<String> contentTypesToCompress() {
        return this.innerProperties() == null ? null : this.innerProperties().contentTypesToCompress();
    }

    public EndpointUpdateParameters withContentTypesToCompress(List<String> contentTypesToCompress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withContentTypesToCompress(contentTypesToCompress);
        return this;
    }

    public String originHostHeader() {
        return this.innerProperties() == null ? null : this.innerProperties().originHostHeader();
    }

    public EndpointUpdateParameters withOriginHostHeader(String originHostHeader) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withOriginHostHeader(originHostHeader);
        return this;
    }

    public Boolean isCompressionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isCompressionEnabled();
    }

    public EndpointUpdateParameters withIsCompressionEnabled(Boolean isCompressionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withIsCompressionEnabled(isCompressionEnabled);
        return this;
    }

    public Boolean isHttpAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isHttpAllowed();
    }

    public EndpointUpdateParameters withIsHttpAllowed(Boolean isHttpAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withIsHttpAllowed(isHttpAllowed);
        return this;
    }

    public Boolean isHttpsAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isHttpsAllowed();
    }

    public EndpointUpdateParameters withIsHttpsAllowed(Boolean isHttpsAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withIsHttpsAllowed(isHttpsAllowed);
        return this;
    }

    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.innerProperties() == null ? null : this.innerProperties().queryStringCachingBehavior();
    }

    public EndpointUpdateParameters withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withQueryStringCachingBehavior(queryStringCachingBehavior);
        return this;
    }

    public OptimizationType optimizationType() {
        return this.innerProperties() == null ? null : this.innerProperties().optimizationType();
    }

    public EndpointUpdateParameters withOptimizationType(OptimizationType optimizationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withOptimizationType(optimizationType);
        return this;
    }

    public String probePath() {
        return this.innerProperties() == null ? null : this.innerProperties().probePath();
    }

    public EndpointUpdateParameters withProbePath(String probePath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withProbePath(probePath);
        return this;
    }

    public List<GeoFilter> geoFilters() {
        return this.innerProperties() == null ? null : this.innerProperties().geoFilters();
    }

    public EndpointUpdateParameters withGeoFilters(List<GeoFilter> geoFilters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withGeoFilters(geoFilters);
        return this;
    }

    public ResourceReference defaultOriginGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultOriginGroup();
    }

    public EndpointUpdateParameters withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withDefaultOriginGroup(defaultOriginGroup);
        return this;
    }

    public List<UrlSigningKey> urlSigningKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().urlSigningKeys();
    }

    public EndpointUpdateParameters withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withUrlSigningKeys(urlSigningKeys);
        return this;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryPolicy();
    }

    public EndpointUpdateParameters withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withDeliveryPolicy(deliveryPolicy);
        return this;
    }

    public EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.innerProperties() == null ? null : this.innerProperties().webApplicationFirewallPolicyLink();
    }

    public EndpointUpdateParameters withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

