/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ActionType;
import com.azure.resourcemanager.cdn.models.CustomRuleEnabledState;
import com.azure.resourcemanager.cdn.models.MatchCondition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CustomRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CustomRule.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="enabledState")
    private CustomRuleEnabledState enabledState;
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="matchConditions", required=true)
    private List<MatchCondition> matchConditions;
    @JsonProperty(value="action", required=true)
    private ActionType action;

    public String name() {
        return this.name;
    }

    public CustomRule withName(String name) {
        this.name = name;
        return this;
    }

    public CustomRuleEnabledState enabledState() {
        return this.enabledState;
    }

    public CustomRule withEnabledState(CustomRuleEnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public CustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    public CustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public ActionType action() {
        return this.action;
    }

    public CustomRule withAction(ActionType action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model CustomRule"));
        }
        if (this.matchConditions() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchConditions in model CustomRule"));
        }
        this.matchConditions().forEach(e -> e.validate());
        if (this.action() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model CustomRule"));
        }
    }
}

