/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.OperationProperties;
import com.azure.resourcemanager.cdn.models.OperationDisplay;
import com.azure.resourcemanager.cdn.models.ServiceSpecification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class OperationInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OperationInner.class);
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="isDataAction")
    private Boolean isDataAction;
    @JsonProperty(value="display")
    private OperationDisplay display;
    @JsonProperty(value="origin", access=JsonProperty.Access.WRITE_ONLY)
    private String origin;
    @JsonProperty(value="properties")
    private OperationProperties innerOperationProperties;

    public String name() {
        return this.name;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    private OperationProperties innerOperationProperties() {
        return this.innerOperationProperties;
    }

    public ServiceSpecification serviceSpecification() {
        return this.innerOperationProperties() == null ? null : this.innerOperationProperties().serviceSpecification();
    }

    public OperationInner withServiceSpecification(ServiceSpecification serviceSpecification) {
        if (this.innerOperationProperties() == null) {
            this.innerOperationProperties = new OperationProperties();
        }
        this.innerOperationProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerOperationProperties() != null) {
            this.innerOperationProperties().validate();
        }
    }
}

