// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for WafMatchVariable. */
public final class WafMatchVariable extends ExpandableStringEnum<WafMatchVariable> {
    /** Static value RemoteAddr for WafMatchVariable. */
    public static final WafMatchVariable REMOTE_ADDR = fromString("RemoteAddr");

    /** Static value SocketAddr for WafMatchVariable. */
    public static final WafMatchVariable SOCKET_ADDR = fromString("SocketAddr");

    /** Static value RequestMethod for WafMatchVariable. */
    public static final WafMatchVariable REQUEST_METHOD = fromString("RequestMethod");

    /** Static value RequestHeader for WafMatchVariable. */
    public static final WafMatchVariable REQUEST_HEADER = fromString("RequestHeader");

    /** Static value RequestUri for WafMatchVariable. */
    public static final WafMatchVariable REQUEST_URI = fromString("RequestUri");

    /** Static value QueryString for WafMatchVariable. */
    public static final WafMatchVariable QUERY_STRING = fromString("QueryString");

    /** Static value RequestBody for WafMatchVariable. */
    public static final WafMatchVariable REQUEST_BODY = fromString("RequestBody");

    /** Static value Cookies for WafMatchVariable. */
    public static final WafMatchVariable COOKIES = fromString("Cookies");

    /** Static value PostArgs for WafMatchVariable. */
    public static final WafMatchVariable POST_ARGS = fromString("PostArgs");

    /**
     * Creates or finds a WafMatchVariable from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WafMatchVariable.
     */
    @JsonCreator
    public static WafMatchVariable fromString(String name) {
        return fromString(name, WafMatchVariable.class);
    }

    /** @return known WafMatchVariable values. */
    public static Collection<WafMatchVariable> values() {
        return values(WafMatchVariable.class);
    }
}
