// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for RuleQueryStringCachingBehavior. */
public final class RuleQueryStringCachingBehavior extends ExpandableStringEnum<RuleQueryStringCachingBehavior> {
    /** Static value IgnoreQueryString for RuleQueryStringCachingBehavior. */
    public static final RuleQueryStringCachingBehavior IGNORE_QUERY_STRING = fromString("IgnoreQueryString");

    /** Static value UseQueryString for RuleQueryStringCachingBehavior. */
    public static final RuleQueryStringCachingBehavior USE_QUERY_STRING = fromString("UseQueryString");

    /** Static value IgnoreSpecifiedQueryStrings for RuleQueryStringCachingBehavior. */
    public static final RuleQueryStringCachingBehavior IGNORE_SPECIFIED_QUERY_STRINGS =
        fromString("IgnoreSpecifiedQueryStrings");

    /** Static value IncludeSpecifiedQueryStrings for RuleQueryStringCachingBehavior. */
    public static final RuleQueryStringCachingBehavior INCLUDE_SPECIFIED_QUERY_STRINGS =
        fromString("IncludeSpecifiedQueryStrings");

    /**
     * Creates or finds a RuleQueryStringCachingBehavior from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RuleQueryStringCachingBehavior.
     */
    @JsonCreator
    public static RuleQueryStringCachingBehavior fromString(String name) {
        return fromString(name, RuleQueryStringCachingBehavior.class);
    }

    /** @return known RuleQueryStringCachingBehavior values. */
    public static Collection<RuleQueryStringCachingBehavior> values() {
        return values(RuleQueryStringCachingBehavior.class);
    }
}
