// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.Status;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Output of the validated secret. */
@Fluent
public final class ValidateSecretOutputInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ValidateSecretOutputInner.class);

    /*
     * The validation status.
     */
    @JsonProperty(value = "status")
    private Status status;

    /*
     * Detailed error message
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the status property: The validation status.
     *
     * @return the status value.
     */
    public Status status() {
        return this.status;
    }

    /**
     * Set the status property: The validation status.
     *
     * @param status the status value to set.
     * @return the ValidateSecretOutputInner object itself.
     */
    public ValidateSecretOutputInner withStatus(Status status) {
        this.status = status;
        return this;
    }

    /**
     * Get the message property: Detailed error message.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Detailed error message.
     *
     * @param message the message value to set.
     * @return the ValidateSecretOutputInner object itself.
     */
    public ValidateSecretOutputInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
