// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.IpAddressGroup;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users. */
@Fluent
public final class EdgeNodeInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EdgeNodeInner.class);

    /*
     * The JSON object that contains the properties required to create an
     * edgenode.
     */
    @JsonProperty(value = "properties")
    private EdgeNodeProperties innerProperties;

    /*
     * Read only system data
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: The JSON object that contains the properties required to create an edgenode.
     *
     * @return the innerProperties value.
     */
    private EdgeNodeProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Read only system data.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the ipAddressGroups property: List of ip address groups.
     *
     * @return the ipAddressGroups value.
     */
    public List<IpAddressGroup> ipAddressGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddressGroups();
    }

    /**
     * Set the ipAddressGroups property: List of ip address groups.
     *
     * @param ipAddressGroups the ipAddressGroups value to set.
     * @return the EdgeNodeInner object itself.
     */
    public EdgeNodeInner withIpAddressGroups(List<IpAddressGroup> ipAddressGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EdgeNodeProperties();
        }
        this.innerProperties().withIpAddressGroups(ipAddressGroups);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
