/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedPropertiesPrincipal;
import com.azure.resourcemanager.authorization.models.ExpandedPropertiesRoleDefinition;
import com.azure.resourcemanager.authorization.models.ExpandedPropertiesScope;
import java.io.IOException;

public final class ExpandedProperties
implements JsonSerializable<ExpandedProperties> {
    private ExpandedPropertiesScope scope;
    private ExpandedPropertiesRoleDefinition roleDefinition;
    private ExpandedPropertiesPrincipal principal;

    public ExpandedPropertiesScope scope() {
        return this.scope;
    }

    public ExpandedProperties withScope(ExpandedPropertiesScope scope) {
        this.scope = scope;
        return this;
    }

    public ExpandedPropertiesRoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    public ExpandedProperties withRoleDefinition(ExpandedPropertiesRoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    public ExpandedPropertiesPrincipal principal() {
        return this.principal;
    }

    public ExpandedProperties withPrincipal(ExpandedPropertiesPrincipal principal) {
        this.principal = principal;
        return this;
    }

    public void validate() {
        if (this.scope() != null) {
            this.scope().validate();
        }
        if (this.roleDefinition() != null) {
            this.roleDefinition().validate();
        }
        if (this.principal() != null) {
            this.principal().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scope", (JsonSerializable)this.scope);
        jsonWriter.writeJsonField("roleDefinition", (JsonSerializable)this.roleDefinition);
        jsonWriter.writeJsonField("principal", (JsonSerializable)this.principal);
        return jsonWriter.writeEndObject();
    }

    public static ExpandedProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExpandedProperties)jsonReader.readObject(reader -> {
            ExpandedProperties deserializedExpandedProperties = new ExpandedProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedExpandedProperties.scope = ExpandedPropertiesScope.fromJson(reader);
                    continue;
                }
                if ("roleDefinition".equals(fieldName)) {
                    deserializedExpandedProperties.roleDefinition = ExpandedPropertiesRoleDefinition.fromJson(reader);
                    continue;
                }
                if ("principal".equals(fieldName)) {
                    deserializedExpandedProperties.principal = ExpandedPropertiesPrincipal.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpandedProperties;
        });
    }
}

