/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOperationError;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTeamsAsyncOperationStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTeamsAsyncOperationType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTeamsAsyncOperation
extends MicrosoftGraphEntity {
    private Integer attemptsCount;
    private OffsetDateTime createdDateTime;
    private MicrosoftGraphOperationError error;
    private OffsetDateTime lastActionDateTime;
    private MicrosoftGraphTeamsAsyncOperationType operationType;
    private MicrosoftGraphTeamsAsyncOperationStatus status;
    private String targetResourceId;
    private String targetResourceLocation;
    private Map<String, Object> additionalProperties;

    public Integer attemptsCount() {
        return this.attemptsCount;
    }

    public MicrosoftGraphTeamsAsyncOperation withAttemptsCount(Integer attemptsCount) {
        this.attemptsCount = attemptsCount;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphTeamsAsyncOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public MicrosoftGraphOperationError error() {
        return this.error;
    }

    public MicrosoftGraphTeamsAsyncOperation withError(MicrosoftGraphOperationError error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime lastActionDateTime() {
        return this.lastActionDateTime;
    }

    public MicrosoftGraphTeamsAsyncOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        this.lastActionDateTime = lastActionDateTime;
        return this;
    }

    public MicrosoftGraphTeamsAsyncOperationType operationType() {
        return this.operationType;
    }

    public MicrosoftGraphTeamsAsyncOperation withOperationType(MicrosoftGraphTeamsAsyncOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public MicrosoftGraphTeamsAsyncOperationStatus status() {
        return this.status;
    }

    public MicrosoftGraphTeamsAsyncOperation withStatus(MicrosoftGraphTeamsAsyncOperationStatus status) {
        this.status = status;
        return this;
    }

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public MicrosoftGraphTeamsAsyncOperation withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String targetResourceLocation() {
        return this.targetResourceLocation;
    }

    public MicrosoftGraphTeamsAsyncOperation withTargetResourceLocation(String targetResourceLocation) {
        this.targetResourceLocation = targetResourceLocation;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTeamsAsyncOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTeamsAsyncOperation withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeNumberField("attemptsCount", (Number)this.attemptsCount);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("lastActionDateTime", this.lastActionDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastActionDateTime));
        jsonWriter.writeStringField("operationType", this.operationType == null ? null : this.operationType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceLocation", this.targetResourceLocation);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTeamsAsyncOperation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTeamsAsyncOperation)jsonReader.readObject(reader -> {
            MicrosoftGraphTeamsAsyncOperation deserializedMicrosoftGraphTeamsAsyncOperation = new MicrosoftGraphTeamsAsyncOperation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.withId(reader.getString());
                    continue;
                }
                if ("attemptsCount".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.attemptsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.error = MicrosoftGraphOperationError.fromJson(reader);
                    continue;
                }
                if ("lastActionDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.lastActionDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("operationType".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.operationType = MicrosoftGraphTeamsAsyncOperationType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.status = MicrosoftGraphTeamsAsyncOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("targetResourceId".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAsyncOperation.targetResourceLocation = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTeamsAsyncOperation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTeamsAsyncOperation;
        });
    }
}

