/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFile;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFileSystemInfo;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFolder;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphImage;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPackage;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShared;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharepointIds;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSpecialFolder;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphVideo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphRemoteItem
implements JsonSerializable<MicrosoftGraphRemoteItem> {
    private MicrosoftGraphIdentitySet createdBy;
    private OffsetDateTime createdDateTime;
    private MicrosoftGraphFile file;
    private MicrosoftGraphFileSystemInfo fileSystemInfo;
    private MicrosoftGraphFolder folder;
    private String id;
    private MicrosoftGraphImage image;
    private MicrosoftGraphIdentitySet lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;
    private String name;
    private MicrosoftGraphPackage packageProperty;
    private MicrosoftGraphItemReference parentReference;
    private MicrosoftGraphShared shared;
    private MicrosoftGraphSharepointIds sharepointIds;
    private Long size;
    private MicrosoftGraphSpecialFolder specialFolder;
    private MicrosoftGraphVideo video;
    private String webDavUrl;
    private String webUrl;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    public MicrosoftGraphRemoteItem withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphRemoteItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public MicrosoftGraphFile file() {
        return this.file;
    }

    public MicrosoftGraphRemoteItem withFile(MicrosoftGraphFile file) {
        this.file = file;
        return this;
    }

    public MicrosoftGraphFileSystemInfo fileSystemInfo() {
        return this.fileSystemInfo;
    }

    public MicrosoftGraphRemoteItem withFileSystemInfo(MicrosoftGraphFileSystemInfo fileSystemInfo) {
        this.fileSystemInfo = fileSystemInfo;
        return this;
    }

    public MicrosoftGraphFolder folder() {
        return this.folder;
    }

    public MicrosoftGraphRemoteItem withFolder(MicrosoftGraphFolder folder) {
        this.folder = folder;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MicrosoftGraphRemoteItem withId(String id) {
        this.id = id;
        return this;
    }

    public MicrosoftGraphImage image() {
        return this.image;
    }

    public MicrosoftGraphRemoteItem withImage(MicrosoftGraphImage image) {
        this.image = image;
        return this;
    }

    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public MicrosoftGraphRemoteItem withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphRemoteItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphRemoteItem withName(String name) {
        this.name = name;
        return this;
    }

    public MicrosoftGraphPackage packageProperty() {
        return this.packageProperty;
    }

    public MicrosoftGraphRemoteItem withPackageProperty(MicrosoftGraphPackage packageProperty) {
        this.packageProperty = packageProperty;
        return this;
    }

    public MicrosoftGraphItemReference parentReference() {
        return this.parentReference;
    }

    public MicrosoftGraphRemoteItem withParentReference(MicrosoftGraphItemReference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    public MicrosoftGraphShared shared() {
        return this.shared;
    }

    public MicrosoftGraphRemoteItem withShared(MicrosoftGraphShared shared) {
        this.shared = shared;
        return this;
    }

    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    public MicrosoftGraphRemoteItem withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    public Long size() {
        return this.size;
    }

    public MicrosoftGraphRemoteItem withSize(Long size) {
        this.size = size;
        return this;
    }

    public MicrosoftGraphSpecialFolder specialFolder() {
        return this.specialFolder;
    }

    public MicrosoftGraphRemoteItem withSpecialFolder(MicrosoftGraphSpecialFolder specialFolder) {
        this.specialFolder = specialFolder;
        return this;
    }

    public MicrosoftGraphVideo video() {
        return this.video;
    }

    public MicrosoftGraphRemoteItem withVideo(MicrosoftGraphVideo video) {
        this.video = video;
        return this;
    }

    public String webDavUrl() {
        return this.webDavUrl;
    }

    public MicrosoftGraphRemoteItem withWebDavUrl(String webDavUrl) {
        this.webDavUrl = webDavUrl;
        return this;
    }

    public String webUrl() {
        return this.webUrl;
    }

    public MicrosoftGraphRemoteItem withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphRemoteItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.createdBy() != null) {
            this.createdBy().validate();
        }
        if (this.file() != null) {
            this.file().validate();
        }
        if (this.fileSystemInfo() != null) {
            this.fileSystemInfo().validate();
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
        if (this.packageProperty() != null) {
            this.packageProperty().validate();
        }
        if (this.parentReference() != null) {
            this.parentReference().validate();
        }
        if (this.shared() != null) {
            this.shared().validate();
        }
        if (this.sharepointIds() != null) {
            this.sharepointIds().validate();
        }
        if (this.specialFolder() != null) {
            this.specialFolder().validate();
        }
        if (this.video() != null) {
            this.video().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeJsonField("file", (JsonSerializable)this.file);
        jsonWriter.writeJsonField("fileSystemInfo", (JsonSerializable)this.fileSystemInfo);
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("image", (JsonSerializable)this.image);
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("package", (JsonSerializable)this.packageProperty);
        jsonWriter.writeJsonField("parentReference", (JsonSerializable)this.parentReference);
        jsonWriter.writeJsonField("shared", (JsonSerializable)this.shared);
        jsonWriter.writeJsonField("sharepointIds", (JsonSerializable)this.sharepointIds);
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeJsonField("specialFolder", (JsonSerializable)this.specialFolder);
        jsonWriter.writeJsonField("video", (JsonSerializable)this.video);
        jsonWriter.writeStringField("webDavUrl", this.webDavUrl);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphRemoteItem fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphRemoteItem)jsonReader.readObject(reader -> {
            MicrosoftGraphRemoteItem deserializedMicrosoftGraphRemoteItem = new MicrosoftGraphRemoteItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.file = MicrosoftGraphFile.fromJson(reader);
                    continue;
                }
                if ("fileSystemInfo".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.fileSystemInfo = MicrosoftGraphFileSystemInfo.fromJson(reader);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.folder = MicrosoftGraphFolder.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.id = reader.getString();
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.image = MicrosoftGraphImage.fromJson(reader);
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.lastModifiedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.name = reader.getString();
                    continue;
                }
                if ("package".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.packageProperty = MicrosoftGraphPackage.fromJson(reader);
                    continue;
                }
                if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.parentReference = MicrosoftGraphItemReference.fromJson(reader);
                    continue;
                }
                if ("shared".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.shared = MicrosoftGraphShared.fromJson(reader);
                    continue;
                }
                if ("sharepointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.sharepointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("specialFolder".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.specialFolder = MicrosoftGraphSpecialFolder.fromJson(reader);
                    continue;
                }
                if ("video".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.video = MicrosoftGraphVideo.fromJson(reader);
                    continue;
                }
                if ("webDavUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.webDavUrl = reader.getString();
                    continue;
                }
                if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.webUrl = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphRemoteItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphRemoteItem;
        });
    }
}

