/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteEntityBaseModel;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MicrosoftGraphOnenoteResource
extends MicrosoftGraphOnenoteEntityBaseModel {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Base64Url content;
    private String contentUrl;
    private Map<String, Object> additionalProperties;

    public byte[] content() {
        if (this.content == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.decodedBytes();
    }

    public MicrosoftGraphOnenoteResource withContent(byte[] content) {
        this.content = content == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])content));
        return this;
    }

    public String contentUrl() {
        return this.contentUrl;
    }

    public MicrosoftGraphOnenoteResource withContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnenoteResource withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteResource withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("self", this.self());
        jsonWriter.writeStringField("content", Objects.toString(this.content, null));
        jsonWriter.writeStringField("contentUrl", this.contentUrl);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnenoteResource fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnenoteResource)jsonReader.readObject(reader -> {
            MicrosoftGraphOnenoteResource deserializedMicrosoftGraphOnenoteResource = new MicrosoftGraphOnenoteResource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteResource.withId(reader.getString());
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteResource.withSelf(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteResource.content = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("contentUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteResource.contentUrl = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnenoteResource.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnenoteResource;
        });
    }
}

