/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphColumnLink;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphContentTypeOrder;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphContentType
extends MicrosoftGraphEntity {
    private String description;
    private String group;
    private Boolean hidden;
    private MicrosoftGraphItemReference inheritedFrom;
    private String name;
    private MicrosoftGraphContentTypeOrder order;
    private String parentId;
    private Boolean readOnly;
    private Boolean sealed;
    private List<MicrosoftGraphColumnLink> columnLinks;
    private Map<String, Object> additionalProperties;

    public String description() {
        return this.description;
    }

    public MicrosoftGraphContentType withDescription(String description) {
        this.description = description;
        return this;
    }

    public String group() {
        return this.group;
    }

    public MicrosoftGraphContentType withGroup(String group) {
        this.group = group;
        return this;
    }

    public Boolean hidden() {
        return this.hidden;
    }

    public MicrosoftGraphContentType withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public MicrosoftGraphItemReference inheritedFrom() {
        return this.inheritedFrom;
    }

    public MicrosoftGraphContentType withInheritedFrom(MicrosoftGraphItemReference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphContentType withName(String name) {
        this.name = name;
        return this;
    }

    public MicrosoftGraphContentTypeOrder order() {
        return this.order;
    }

    public MicrosoftGraphContentType withOrder(MicrosoftGraphContentTypeOrder order) {
        this.order = order;
        return this;
    }

    public String parentId() {
        return this.parentId;
    }

    public MicrosoftGraphContentType withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public MicrosoftGraphContentType withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean sealed() {
        return this.sealed;
    }

    public MicrosoftGraphContentType withSealed(Boolean sealed) {
        this.sealed = sealed;
        return this;
    }

    public List<MicrosoftGraphColumnLink> columnLinks() {
        return this.columnLinks;
    }

    public MicrosoftGraphContentType withColumnLinks(List<MicrosoftGraphColumnLink> columnLinks) {
        this.columnLinks = columnLinks;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphContentType withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphContentType withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.inheritedFrom() != null) {
            this.inheritedFrom().validate();
        }
        if (this.order() != null) {
            this.order().validate();
        }
        if (this.columnLinks() != null) {
            this.columnLinks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("group", this.group);
        jsonWriter.writeBooleanField("hidden", this.hidden);
        jsonWriter.writeJsonField("inheritedFrom", (JsonSerializable)this.inheritedFrom);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("order", (JsonSerializable)this.order);
        jsonWriter.writeStringField("parentId", this.parentId);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        jsonWriter.writeBooleanField("sealed", this.sealed);
        jsonWriter.writeArrayField("columnLinks", this.columnLinks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphContentType fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphContentType)jsonReader.readObject(reader -> {
            MicrosoftGraphContentType deserializedMicrosoftGraphContentType = new MicrosoftGraphContentType();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.withId(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.description = reader.getString();
                    continue;
                }
                if ("group".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.group = reader.getString();
                    continue;
                }
                if ("hidden".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.hidden = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("inheritedFrom".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.inheritedFrom = MicrosoftGraphItemReference.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.name = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.order = MicrosoftGraphContentTypeOrder.fromJson(reader);
                    continue;
                }
                if ("parentId".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.parentId = reader.getString();
                    continue;
                }
                if ("readOnly".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.readOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sealed".equals(fieldName)) {
                    deserializedMicrosoftGraphContentType.sealed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("columnLinks".equals(fieldName)) {
                    List columnLinks;
                    deserializedMicrosoftGraphContentType.columnLinks = columnLinks = reader.readArray(reader1 -> MicrosoftGraphColumnLink.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphContentType.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphContentType;
        });
    }
}

