// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.RoleEligibilityScheduleInner;
import java.io.IOException;
import java.util.List;

/**
 * role eligibility schedule list operation result.
 */
@Fluent
public final class RoleEligibilityScheduleListResult implements JsonSerializable<RoleEligibilityScheduleListResult> {
    /*
     * role eligibility schedule list.
     */
    private List<RoleEligibilityScheduleInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RoleEligibilityScheduleListResult class.
     */
    public RoleEligibilityScheduleListResult() {
    }

    /**
     * Get the value property: role eligibility schedule list.
     * 
     * @return the value value.
     */
    public List<RoleEligibilityScheduleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: role eligibility schedule list.
     * 
     * @param value the value value to set.
     * @return the RoleEligibilityScheduleListResult object itself.
     */
    public RoleEligibilityScheduleListResult withValue(List<RoleEligibilityScheduleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RoleEligibilityScheduleListResult object itself.
     */
    public RoleEligibilityScheduleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleEligibilityScheduleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleEligibilityScheduleListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleEligibilityScheduleListResult.
     */
    public static RoleEligibilityScheduleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleEligibilityScheduleListResult deserializedRoleEligibilityScheduleListResult
                = new RoleEligibilityScheduleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RoleEligibilityScheduleInner> value
                        = reader.readArray(reader1 -> RoleEligibilityScheduleInner.fromJson(reader1));
                    deserializedRoleEligibilityScheduleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleEligibilityScheduleListResult;
        });
    }
}
