// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PolicyAssignmentProperties;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import java.io.IOException;
import java.util.List;

/**
 * Role management policy.
 */
@Fluent
public final class RoleManagementPolicyAssignmentInner
    implements JsonSerializable<RoleManagementPolicyAssignmentInner> {
    /*
     * The role management policy Id.
     */
    private String id;

    /*
     * The role management policy name.
     */
    private String name;

    /*
     * The role management policy type.
     */
    private String type;

    /*
     * Role management policy properties.
     */
    private RoleManagementPolicyAssignmentProperties innerProperties;

    /**
     * Creates an instance of RoleManagementPolicyAssignmentInner class.
     */
    public RoleManagementPolicyAssignmentInner() {
    }

    /**
     * Get the id property: The role management policy Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The role management policy name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The role management policy type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Role management policy properties.
     * 
     * @return the innerProperties value.
     */
    private RoleManagementPolicyAssignmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: The role management policy scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The role management policy scope.
     * 
     * @param scope the scope value to set.
     * @return the RoleManagementPolicyAssignmentInner object itself.
     */
    public RoleManagementPolicyAssignmentInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyAssignmentProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the roleDefinitionId property: The role definition of management policy assignment.
     * 
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The role definition of management policy assignment.
     * 
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleManagementPolicyAssignmentInner object itself.
     */
    public RoleManagementPolicyAssignmentInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyAssignmentProperties();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the policyId property: The policy id role management policy assignment.
     * 
     * @return the policyId value.
     */
    public String policyId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyId();
    }

    /**
     * Set the policyId property: The policy id role management policy assignment.
     * 
     * @param policyId the policyId value to set.
     * @return the RoleManagementPolicyAssignmentInner object itself.
     */
    public RoleManagementPolicyAssignmentInner withPolicyId(String policyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyAssignmentProperties();
        }
        this.innerProperties().withPolicyId(policyId);
        return this;
    }

    /**
     * Get the effectiveRules property: The readonly computed rule applied to the policy.
     * 
     * @return the effectiveRules value.
     */
    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveRules();
    }

    /**
     * Get the policyAssignmentProperties property: Additional properties of scope, role definition and policy.
     * 
     * @return the policyAssignmentProperties value.
     */
    public PolicyAssignmentProperties policyAssignmentProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().policyAssignmentProperties();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleManagementPolicyAssignmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleManagementPolicyAssignmentInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleManagementPolicyAssignmentInner.
     */
    public static RoleManagementPolicyAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleManagementPolicyAssignmentInner deserializedRoleManagementPolicyAssignmentInner
                = new RoleManagementPolicyAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentInner.innerProperties
                        = RoleManagementPolicyAssignmentProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleManagementPolicyAssignmentInner;
        });
    }
}
