// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a working hours.
 */
@Fluent
public final class MicrosoftGraphWorkingHours implements JsonSerializable<MicrosoftGraphWorkingHours> {
    /*
     * The days of the week on which the user works.
     */
    private List<MicrosoftGraphDayOfWeek> daysOfWeek;

    /*
     * The time of the day that the user stops working.
     */
    private String endTime;

    /*
     * The time of the day that the user starts working.
     */
    private String startTime;

    /*
     * timeZoneBase
     */
    private MicrosoftGraphTimeZoneBase timeZone;

    /*
     * workingHours
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkingHours class.
     */
    public MicrosoftGraphWorkingHours() {
    }

    /**
     * Get the daysOfWeek property: The days of the week on which the user works.
     * 
     * @return the daysOfWeek value.
     */
    public List<MicrosoftGraphDayOfWeek> daysOfWeek() {
        return this.daysOfWeek;
    }

    /**
     * Set the daysOfWeek property: The days of the week on which the user works.
     * 
     * @param daysOfWeek the daysOfWeek value to set.
     * @return the MicrosoftGraphWorkingHours object itself.
     */
    public MicrosoftGraphWorkingHours withDaysOfWeek(List<MicrosoftGraphDayOfWeek> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    /**
     * Get the endTime property: The time of the day that the user stops working.
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The time of the day that the user stops working.
     * 
     * @param endTime the endTime value to set.
     * @return the MicrosoftGraphWorkingHours object itself.
     */
    public MicrosoftGraphWorkingHours withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the startTime property: The time of the day that the user starts working.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The time of the day that the user starts working.
     * 
     * @param startTime the startTime value to set.
     * @return the MicrosoftGraphWorkingHours object itself.
     */
    public MicrosoftGraphWorkingHours withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the timeZone property: timeZoneBase.
     * 
     * @return the timeZone value.
     */
    public MicrosoftGraphTimeZoneBase timeZone() {
        return this.timeZone;
    }

    /**
     * Set the timeZone property: timeZoneBase.
     * 
     * @param timeZone the timeZone value to set.
     * @return the MicrosoftGraphWorkingHours object itself.
     */
    public MicrosoftGraphWorkingHours withTimeZone(MicrosoftGraphTimeZoneBase timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    /**
     * Get the additionalProperties property: workingHours.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workingHours.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkingHours object itself.
     */
    public MicrosoftGraphWorkingHours withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timeZone() != null) {
            timeZone().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("daysOfWeek", this.daysOfWeek,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeJsonField("timeZone", this.timeZone);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkingHours from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkingHours if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkingHours.
     */
    public static MicrosoftGraphWorkingHours fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkingHours deserializedMicrosoftGraphWorkingHours = new MicrosoftGraphWorkingHours();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("daysOfWeek".equals(fieldName)) {
                    List<MicrosoftGraphDayOfWeek> daysOfWeek
                        = reader.readArray(reader1 -> MicrosoftGraphDayOfWeek.fromString(reader1.getString()));
                    deserializedMicrosoftGraphWorkingHours.daysOfWeek = daysOfWeek;
                } else if ("endTime".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkingHours.endTime = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkingHours.startTime = reader.getString();
                } else if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkingHours.timeZone = MicrosoftGraphTimeZoneBase.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkingHours.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkingHours;
        });
    }
}
