// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook worksheet protection options.
 */
@Fluent
public final class MicrosoftGraphWorkbookWorksheetProtectionOptions
    implements JsonSerializable<MicrosoftGraphWorkbookWorksheetProtectionOptions> {
    /*
     * Represents the worksheet protection option of allowing using auto filter feature.
     */
    private Boolean allowAutoFilter;

    /*
     * Represents the worksheet protection option of allowing deleting columns.
     */
    private Boolean allowDeleteColumns;

    /*
     * Represents the worksheet protection option of allowing deleting rows.
     */
    private Boolean allowDeleteRows;

    /*
     * Represents the worksheet protection option of allowing formatting cells.
     */
    private Boolean allowFormatCells;

    /*
     * Represents the worksheet protection option of allowing formatting columns.
     */
    private Boolean allowFormatColumns;

    /*
     * Represents the worksheet protection option of allowing formatting rows.
     */
    private Boolean allowFormatRows;

    /*
     * Represents the worksheet protection option of allowing inserting columns.
     */
    private Boolean allowInsertColumns;

    /*
     * Represents the worksheet protection option of allowing inserting hyperlinks.
     */
    private Boolean allowInsertHyperlinks;

    /*
     * Represents the worksheet protection option of allowing inserting rows.
     */
    private Boolean allowInsertRows;

    /*
     * Represents the worksheet protection option of allowing using pivot table feature.
     */
    private Boolean allowPivotTables;

    /*
     * Represents the worksheet protection option of allowing using sort feature.
     */
    private Boolean allowSort;

    /*
     * workbookWorksheetProtectionOptions
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookWorksheetProtectionOptions class.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions() {
    }

    /**
     * Get the allowAutoFilter property: Represents the worksheet protection option of allowing using auto filter
     * feature.
     * 
     * @return the allowAutoFilter value.
     */
    public Boolean allowAutoFilter() {
        return this.allowAutoFilter;
    }

    /**
     * Set the allowAutoFilter property: Represents the worksheet protection option of allowing using auto filter
     * feature.
     * 
     * @param allowAutoFilter the allowAutoFilter value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowAutoFilter(Boolean allowAutoFilter) {
        this.allowAutoFilter = allowAutoFilter;
        return this;
    }

    /**
     * Get the allowDeleteColumns property: Represents the worksheet protection option of allowing deleting columns.
     * 
     * @return the allowDeleteColumns value.
     */
    public Boolean allowDeleteColumns() {
        return this.allowDeleteColumns;
    }

    /**
     * Set the allowDeleteColumns property: Represents the worksheet protection option of allowing deleting columns.
     * 
     * @param allowDeleteColumns the allowDeleteColumns value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowDeleteColumns(Boolean allowDeleteColumns) {
        this.allowDeleteColumns = allowDeleteColumns;
        return this;
    }

    /**
     * Get the allowDeleteRows property: Represents the worksheet protection option of allowing deleting rows.
     * 
     * @return the allowDeleteRows value.
     */
    public Boolean allowDeleteRows() {
        return this.allowDeleteRows;
    }

    /**
     * Set the allowDeleteRows property: Represents the worksheet protection option of allowing deleting rows.
     * 
     * @param allowDeleteRows the allowDeleteRows value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowDeleteRows(Boolean allowDeleteRows) {
        this.allowDeleteRows = allowDeleteRows;
        return this;
    }

    /**
     * Get the allowFormatCells property: Represents the worksheet protection option of allowing formatting cells.
     * 
     * @return the allowFormatCells value.
     */
    public Boolean allowFormatCells() {
        return this.allowFormatCells;
    }

    /**
     * Set the allowFormatCells property: Represents the worksheet protection option of allowing formatting cells.
     * 
     * @param allowFormatCells the allowFormatCells value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowFormatCells(Boolean allowFormatCells) {
        this.allowFormatCells = allowFormatCells;
        return this;
    }

    /**
     * Get the allowFormatColumns property: Represents the worksheet protection option of allowing formatting columns.
     * 
     * @return the allowFormatColumns value.
     */
    public Boolean allowFormatColumns() {
        return this.allowFormatColumns;
    }

    /**
     * Set the allowFormatColumns property: Represents the worksheet protection option of allowing formatting columns.
     * 
     * @param allowFormatColumns the allowFormatColumns value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowFormatColumns(Boolean allowFormatColumns) {
        this.allowFormatColumns = allowFormatColumns;
        return this;
    }

    /**
     * Get the allowFormatRows property: Represents the worksheet protection option of allowing formatting rows.
     * 
     * @return the allowFormatRows value.
     */
    public Boolean allowFormatRows() {
        return this.allowFormatRows;
    }

    /**
     * Set the allowFormatRows property: Represents the worksheet protection option of allowing formatting rows.
     * 
     * @param allowFormatRows the allowFormatRows value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowFormatRows(Boolean allowFormatRows) {
        this.allowFormatRows = allowFormatRows;
        return this;
    }

    /**
     * Get the allowInsertColumns property: Represents the worksheet protection option of allowing inserting columns.
     * 
     * @return the allowInsertColumns value.
     */
    public Boolean allowInsertColumns() {
        return this.allowInsertColumns;
    }

    /**
     * Set the allowInsertColumns property: Represents the worksheet protection option of allowing inserting columns.
     * 
     * @param allowInsertColumns the allowInsertColumns value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowInsertColumns(Boolean allowInsertColumns) {
        this.allowInsertColumns = allowInsertColumns;
        return this;
    }

    /**
     * Get the allowInsertHyperlinks property: Represents the worksheet protection option of allowing inserting
     * hyperlinks.
     * 
     * @return the allowInsertHyperlinks value.
     */
    public Boolean allowInsertHyperlinks() {
        return this.allowInsertHyperlinks;
    }

    /**
     * Set the allowInsertHyperlinks property: Represents the worksheet protection option of allowing inserting
     * hyperlinks.
     * 
     * @param allowInsertHyperlinks the allowInsertHyperlinks value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowInsertHyperlinks(Boolean allowInsertHyperlinks) {
        this.allowInsertHyperlinks = allowInsertHyperlinks;
        return this;
    }

    /**
     * Get the allowInsertRows property: Represents the worksheet protection option of allowing inserting rows.
     * 
     * @return the allowInsertRows value.
     */
    public Boolean allowInsertRows() {
        return this.allowInsertRows;
    }

    /**
     * Set the allowInsertRows property: Represents the worksheet protection option of allowing inserting rows.
     * 
     * @param allowInsertRows the allowInsertRows value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowInsertRows(Boolean allowInsertRows) {
        this.allowInsertRows = allowInsertRows;
        return this;
    }

    /**
     * Get the allowPivotTables property: Represents the worksheet protection option of allowing using pivot table
     * feature.
     * 
     * @return the allowPivotTables value.
     */
    public Boolean allowPivotTables() {
        return this.allowPivotTables;
    }

    /**
     * Set the allowPivotTables property: Represents the worksheet protection option of allowing using pivot table
     * feature.
     * 
     * @param allowPivotTables the allowPivotTables value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowPivotTables(Boolean allowPivotTables) {
        this.allowPivotTables = allowPivotTables;
        return this;
    }

    /**
     * Get the allowSort property: Represents the worksheet protection option of allowing using sort feature.
     * 
     * @return the allowSort value.
     */
    public Boolean allowSort() {
        return this.allowSort;
    }

    /**
     * Set the allowSort property: Represents the worksheet protection option of allowing using sort feature.
     * 
     * @param allowSort the allowSort value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions withAllowSort(Boolean allowSort) {
        this.allowSort = allowSort;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookWorksheetProtectionOptions.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookWorksheetProtectionOptions.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtectionOptions object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowAutoFilter", this.allowAutoFilter);
        jsonWriter.writeBooleanField("allowDeleteColumns", this.allowDeleteColumns);
        jsonWriter.writeBooleanField("allowDeleteRows", this.allowDeleteRows);
        jsonWriter.writeBooleanField("allowFormatCells", this.allowFormatCells);
        jsonWriter.writeBooleanField("allowFormatColumns", this.allowFormatColumns);
        jsonWriter.writeBooleanField("allowFormatRows", this.allowFormatRows);
        jsonWriter.writeBooleanField("allowInsertColumns", this.allowInsertColumns);
        jsonWriter.writeBooleanField("allowInsertHyperlinks", this.allowInsertHyperlinks);
        jsonWriter.writeBooleanField("allowInsertRows", this.allowInsertRows);
        jsonWriter.writeBooleanField("allowPivotTables", this.allowPivotTables);
        jsonWriter.writeBooleanField("allowSort", this.allowSort);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookWorksheetProtectionOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookWorksheetProtectionOptions if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookWorksheetProtectionOptions.
     */
    public static MicrosoftGraphWorkbookWorksheetProtectionOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookWorksheetProtectionOptions deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions
                = new MicrosoftGraphWorkbookWorksheetProtectionOptions();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowAutoFilter".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowAutoFilter
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowDeleteColumns".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowDeleteColumns
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowDeleteRows".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowDeleteRows
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowFormatCells".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowFormatCells
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowFormatColumns".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowFormatColumns
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowFormatRows".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowFormatRows
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowInsertColumns".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowInsertColumns
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowInsertHyperlinks".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowInsertHyperlinks
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowInsertRows".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowInsertRows
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowPivotTables".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowPivotTables
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowSort".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.allowSort
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookWorksheetProtectionOptions;
        });
    }
}
