// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a workbook worksheet.
 */
@Fluent
public final class MicrosoftGraphWorkbookWorksheet extends MicrosoftGraphEntity {
    /*
     * The display name of the worksheet.
     */
    private String name;

    /*
     * The zero-based position of the worksheet within the workbook.
     */
    private Integer position;

    /*
     * The Visibility of the worksheet. The possible values are: Visible, Hidden, VeryHidden.
     */
    private String visibility;

    /*
     * Returns collection of charts that are part of the worksheet. Read-only.
     */
    private List<MicrosoftGraphWorkbookChart> charts;

    /*
     * Returns collection of names that are associated with the worksheet. Read-only.
     */
    private List<MicrosoftGraphWorkbookNamedItem> names;

    /*
     * Collection of PivotTables that are part of the worksheet.
     */
    private List<MicrosoftGraphWorkbookPivotTable> pivotTables;

    /*
     * workbookWorksheetProtection
     */
    private MicrosoftGraphWorkbookWorksheetProtection protection;

    /*
     * Collection of tables that are part of the worksheet. Read-only.
     */
    private List<MicrosoftGraphWorkbookTable> tables;

    /*
     * workbookWorksheet
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookWorksheet class.
     */
    public MicrosoftGraphWorkbookWorksheet() {
    }

    /**
     * Get the name property: The display name of the worksheet.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The display name of the worksheet.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the position property: The zero-based position of the worksheet within the workbook.
     * 
     * @return the position value.
     */
    public Integer position() {
        return this.position;
    }

    /**
     * Set the position property: The zero-based position of the worksheet within the workbook.
     * 
     * @param position the position value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withPosition(Integer position) {
        this.position = position;
        return this;
    }

    /**
     * Get the visibility property: The Visibility of the worksheet. The possible values are: Visible, Hidden,
     * VeryHidden.
     * 
     * @return the visibility value.
     */
    public String visibility() {
        return this.visibility;
    }

    /**
     * Set the visibility property: The Visibility of the worksheet. The possible values are: Visible, Hidden,
     * VeryHidden.
     * 
     * @param visibility the visibility value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withVisibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    /**
     * Get the charts property: Returns collection of charts that are part of the worksheet. Read-only.
     * 
     * @return the charts value.
     */
    public List<MicrosoftGraphWorkbookChart> charts() {
        return this.charts;
    }

    /**
     * Set the charts property: Returns collection of charts that are part of the worksheet. Read-only.
     * 
     * @param charts the charts value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withCharts(List<MicrosoftGraphWorkbookChart> charts) {
        this.charts = charts;
        return this;
    }

    /**
     * Get the names property: Returns collection of names that are associated with the worksheet. Read-only.
     * 
     * @return the names value.
     */
    public List<MicrosoftGraphWorkbookNamedItem> names() {
        return this.names;
    }

    /**
     * Set the names property: Returns collection of names that are associated with the worksheet. Read-only.
     * 
     * @param names the names value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withNames(List<MicrosoftGraphWorkbookNamedItem> names) {
        this.names = names;
        return this;
    }

    /**
     * Get the pivotTables property: Collection of PivotTables that are part of the worksheet.
     * 
     * @return the pivotTables value.
     */
    public List<MicrosoftGraphWorkbookPivotTable> pivotTables() {
        return this.pivotTables;
    }

    /**
     * Set the pivotTables property: Collection of PivotTables that are part of the worksheet.
     * 
     * @param pivotTables the pivotTables value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withPivotTables(List<MicrosoftGraphWorkbookPivotTable> pivotTables) {
        this.pivotTables = pivotTables;
        return this;
    }

    /**
     * Get the protection property: workbookWorksheetProtection.
     * 
     * @return the protection value.
     */
    public MicrosoftGraphWorkbookWorksheetProtection protection() {
        return this.protection;
    }

    /**
     * Set the protection property: workbookWorksheetProtection.
     * 
     * @param protection the protection value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withProtection(MicrosoftGraphWorkbookWorksheetProtection protection) {
        this.protection = protection;
        return this;
    }

    /**
     * Get the tables property: Collection of tables that are part of the worksheet. Read-only.
     * 
     * @return the tables value.
     */
    public List<MicrosoftGraphWorkbookTable> tables() {
        return this.tables;
    }

    /**
     * Set the tables property: Collection of tables that are part of the worksheet. Read-only.
     * 
     * @param tables the tables value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withTables(List<MicrosoftGraphWorkbookTable> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookWorksheet.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookWorksheet.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookWorksheet object itself.
     */
    public MicrosoftGraphWorkbookWorksheet withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookWorksheet withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (charts() != null) {
            charts().forEach(e -> e.validate());
        }
        if (names() != null) {
            names().forEach(e -> e.validate());
        }
        if (pivotTables() != null) {
            pivotTables().forEach(e -> e.validate());
        }
        if (protection() != null) {
            protection().validate();
        }
        if (tables() != null) {
            tables().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("position", this.position);
        jsonWriter.writeStringField("visibility", this.visibility);
        jsonWriter.writeArrayField("charts", this.charts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("names", this.names, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("pivotTables", this.pivotTables, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("protection", this.protection);
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookWorksheet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookWorksheet if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookWorksheet.
     */
    public static MicrosoftGraphWorkbookWorksheet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookWorksheet deserializedMicrosoftGraphWorkbookWorksheet
                = new MicrosoftGraphWorkbookWorksheet();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheet.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheet.name = reader.getString();
                } else if ("position".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheet.position = reader.getNullable(JsonReader::getInt);
                } else if ("visibility".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheet.visibility = reader.getString();
                } else if ("charts".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookChart> charts
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookChart.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookWorksheet.charts = charts;
                } else if ("names".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookNamedItem> names
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookNamedItem.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookWorksheet.names = names;
                } else if ("pivotTables".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookPivotTable> pivotTables
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookPivotTable.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookWorksheet.pivotTables = pivotTables;
                } else if ("protection".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookWorksheet.protection
                        = MicrosoftGraphWorkbookWorksheetProtection.fromJson(reader);
                } else if ("tables".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookTable> tables
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookTable.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookWorksheet.tables = tables;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookWorksheet.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookWorksheet;
        });
    }
}
