// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a workbook table sort.
 */
@Fluent
public final class MicrosoftGraphWorkbookTableSort extends MicrosoftGraphEntity {
    /*
     * Represents the current conditions used to last sort the table. Read-only.
     */
    private List<MicrosoftGraphWorkbookSortField> fields;

    /*
     * Represents whether the casing impacted the last sort of the table. Read-only.
     */
    private Boolean matchCase;

    /*
     * Represents Chinese character ordering method last used to sort the table. The possible values are: PinYin,
     * StrokeCount. Read-only.
     */
    private String method;

    /*
     * workbookTableSort
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookTableSort class.
     */
    public MicrosoftGraphWorkbookTableSort() {
    }

    /**
     * Get the fields property: Represents the current conditions used to last sort the table. Read-only.
     * 
     * @return the fields value.
     */
    public List<MicrosoftGraphWorkbookSortField> fields() {
        return this.fields;
    }

    /**
     * Set the fields property: Represents the current conditions used to last sort the table. Read-only.
     * 
     * @param fields the fields value to set.
     * @return the MicrosoftGraphWorkbookTableSort object itself.
     */
    public MicrosoftGraphWorkbookTableSort withFields(List<MicrosoftGraphWorkbookSortField> fields) {
        this.fields = fields;
        return this;
    }

    /**
     * Get the matchCase property: Represents whether the casing impacted the last sort of the table. Read-only.
     * 
     * @return the matchCase value.
     */
    public Boolean matchCase() {
        return this.matchCase;
    }

    /**
     * Set the matchCase property: Represents whether the casing impacted the last sort of the table. Read-only.
     * 
     * @param matchCase the matchCase value to set.
     * @return the MicrosoftGraphWorkbookTableSort object itself.
     */
    public MicrosoftGraphWorkbookTableSort withMatchCase(Boolean matchCase) {
        this.matchCase = matchCase;
        return this;
    }

    /**
     * Get the method property: Represents Chinese character ordering method last used to sort the table. The possible
     * values are: PinYin, StrokeCount. Read-only.
     * 
     * @return the method value.
     */
    public String method() {
        return this.method;
    }

    /**
     * Set the method property: Represents Chinese character ordering method last used to sort the table. The possible
     * values are: PinYin, StrokeCount. Read-only.
     * 
     * @param method the method value to set.
     * @return the MicrosoftGraphWorkbookTableSort object itself.
     */
    public MicrosoftGraphWorkbookTableSort withMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookTableSort.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookTableSort.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookTableSort object itself.
     */
    public MicrosoftGraphWorkbookTableSort withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookTableSort withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (fields() != null) {
            fields().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("fields", this.fields, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("matchCase", this.matchCase);
        jsonWriter.writeStringField("method", this.method);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookTableSort from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookTableSort if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookTableSort.
     */
    public static MicrosoftGraphWorkbookTableSort fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookTableSort deserializedMicrosoftGraphWorkbookTableSort
                = new MicrosoftGraphWorkbookTableSort();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableSort.withId(reader.getString());
                } else if ("fields".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookSortField> fields
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookSortField.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookTableSort.fields = fields;
                } else if ("matchCase".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableSort.matchCase = reader.getNullable(JsonReader::getBoolean);
                } else if ("method".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableSort.method = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookTableSort.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookTableSort;
        });
    }
}
