// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook table column.
 */
@Fluent
public final class MicrosoftGraphWorkbookTableColumn extends MicrosoftGraphEntity {
    /*
     * Returns the index number of the column within the columns collection of the table. Zero-indexed. Read-only.
     */
    private Integer index;

    /*
     * Returns the name of the table column.
     */
    private String name;

    /*
     * Json
     */
    private Map<String, Object> values;

    /*
     * workbookFilter
     */
    private MicrosoftGraphWorkbookFilter filter;

    /*
     * workbookTableColumn
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookTableColumn class.
     */
    public MicrosoftGraphWorkbookTableColumn() {
    }

    /**
     * Get the index property: Returns the index number of the column within the columns collection of the table.
     * Zero-indexed. Read-only.
     * 
     * @return the index value.
     */
    public Integer index() {
        return this.index;
    }

    /**
     * Set the index property: Returns the index number of the column within the columns collection of the table.
     * Zero-indexed. Read-only.
     * 
     * @param index the index value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withIndex(Integer index) {
        this.index = index;
        return this;
    }

    /**
     * Get the name property: Returns the name of the table column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Returns the name of the table column.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the values property: Json.
     * 
     * @return the values value.
     */
    public Map<String, Object> values() {
        return this.values;
    }

    /**
     * Set the values property: Json.
     * 
     * @param values the values value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withValues(Map<String, Object> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the filter property: workbookFilter.
     * 
     * @return the filter value.
     */
    public MicrosoftGraphWorkbookFilter filter() {
        return this.filter;
    }

    /**
     * Set the filter property: workbookFilter.
     * 
     * @param filter the filter value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withFilter(MicrosoftGraphWorkbookFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookTableColumn.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookTableColumn.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookTableColumn withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (filter() != null) {
            filter().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeNumberField("index", this.index);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("values", this.values, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("filter", this.filter);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookTableColumn from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookTableColumn if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookTableColumn.
     */
    public static MicrosoftGraphWorkbookTableColumn fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookTableColumn deserializedMicrosoftGraphWorkbookTableColumn
                = new MicrosoftGraphWorkbookTableColumn();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableColumn.withId(reader.getString());
                } else if ("index".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableColumn.index = reader.getNullable(JsonReader::getInt);
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableColumn.name = reader.getString();
                } else if ("values".equals(fieldName)) {
                    Map<String, Object> values = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphWorkbookTableColumn.values = values;
                } else if ("filter".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTableColumn.filter
                        = MicrosoftGraphWorkbookFilter.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookTableColumn.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookTableColumn;
        });
    }
}
