// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook operation.
 */
@Fluent
public final class MicrosoftGraphWorkbookOperation extends MicrosoftGraphEntity {
    /*
     * workbookOperationError
     */
    private MicrosoftGraphWorkbookOperationError error;

    /*
     * The resource URI for the result.
     */
    private String resourceLocation;

    /*
     * workbookOperationStatus
     */
    private MicrosoftGraphWorkbookOperationStatus status;

    /*
     * workbookOperation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookOperation class.
     */
    public MicrosoftGraphWorkbookOperation() {
    }

    /**
     * Get the error property: workbookOperationError.
     * 
     * @return the error value.
     */
    public MicrosoftGraphWorkbookOperationError error() {
        return this.error;
    }

    /**
     * Set the error property: workbookOperationError.
     * 
     * @param error the error value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withError(MicrosoftGraphWorkbookOperationError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the resourceLocation property: The resource URI for the result.
     * 
     * @return the resourceLocation value.
     */
    public String resourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Set the resourceLocation property: The resource URI for the result.
     * 
     * @param resourceLocation the resourceLocation value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    /**
     * Get the status property: workbookOperationStatus.
     * 
     * @return the status value.
     */
    public MicrosoftGraphWorkbookOperationStatus status() {
        return this.status;
    }

    /**
     * Set the status property: workbookOperationStatus.
     * 
     * @param status the status value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withStatus(MicrosoftGraphWorkbookOperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookOperation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookOperation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookOperation withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (error() != null) {
            error().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookOperation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookOperation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookOperation.
     */
    public static MicrosoftGraphWorkbookOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookOperation deserializedMicrosoftGraphWorkbookOperation
                = new MicrosoftGraphWorkbookOperation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.withId(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.error
                        = MicrosoftGraphWorkbookOperationError.fromJson(reader);
                } else if ("resourceLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.resourceLocation = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.status
                        = MicrosoftGraphWorkbookOperationStatus.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookOperation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookOperation;
        });
    }
}
