// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook icon.
 */
@Fluent
public final class MicrosoftGraphWorkbookIcon implements JsonSerializable<MicrosoftGraphWorkbookIcon> {
    /*
     * Represents the index of the icon in the given set.
     */
    private Integer index;

    /*
     * Represents the set that the icon is part of. The possible values are: Invalid, ThreeArrows, ThreeArrowsGray,
     * ThreeFlags, ThreeTrafficLights1, ThreeTrafficLights2, ThreeSigns, ThreeSymbols, ThreeSymbols2, FourArrows,
     * FourArrowsGray, FourRedToBlack, FourRating, FourTrafficLights, FiveArrows, FiveArrowsGray, FiveRating,
     * FiveQuarters, ThreeStars, ThreeTriangles, FiveBoxes.
     */
    private String set;

    /*
     * workbookIcon
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookIcon class.
     */
    public MicrosoftGraphWorkbookIcon() {
    }

    /**
     * Get the index property: Represents the index of the icon in the given set.
     * 
     * @return the index value.
     */
    public Integer index() {
        return this.index;
    }

    /**
     * Set the index property: Represents the index of the icon in the given set.
     * 
     * @param index the index value to set.
     * @return the MicrosoftGraphWorkbookIcon object itself.
     */
    public MicrosoftGraphWorkbookIcon withIndex(Integer index) {
        this.index = index;
        return this;
    }

    /**
     * Get the set property: Represents the set that the icon is part of. The possible values are: Invalid, ThreeArrows,
     * ThreeArrowsGray, ThreeFlags, ThreeTrafficLights1, ThreeTrafficLights2, ThreeSigns, ThreeSymbols, ThreeSymbols2,
     * FourArrows, FourArrowsGray, FourRedToBlack, FourRating, FourTrafficLights, FiveArrows, FiveArrowsGray,
     * FiveRating, FiveQuarters, ThreeStars, ThreeTriangles, FiveBoxes.
     * 
     * @return the set value.
     */
    public String set() {
        return this.set;
    }

    /**
     * Set the set property: Represents the set that the icon is part of. The possible values are: Invalid, ThreeArrows,
     * ThreeArrowsGray, ThreeFlags, ThreeTrafficLights1, ThreeTrafficLights2, ThreeSigns, ThreeSymbols, ThreeSymbols2,
     * FourArrows, FourArrowsGray, FourRedToBlack, FourRating, FourTrafficLights, FiveArrows, FiveArrowsGray,
     * FiveRating, FiveQuarters, ThreeStars, ThreeTriangles, FiveBoxes.
     * 
     * @param set the set value to set.
     * @return the MicrosoftGraphWorkbookIcon object itself.
     */
    public MicrosoftGraphWorkbookIcon withSet(String set) {
        this.set = set;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookIcon.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookIcon.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookIcon object itself.
     */
    public MicrosoftGraphWorkbookIcon withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("index", this.index);
        jsonWriter.writeStringField("set", this.set);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookIcon from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookIcon if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookIcon.
     */
    public static MicrosoftGraphWorkbookIcon fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookIcon deserializedMicrosoftGraphWorkbookIcon = new MicrosoftGraphWorkbookIcon();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("index".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookIcon.index = reader.getNullable(JsonReader::getInt);
                } else if ("set".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookIcon.set = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookIcon.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookIcon;
        });
    }
}
