// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook filter.
 */
@Fluent
public final class MicrosoftGraphWorkbookFilter extends MicrosoftGraphEntity {
    /*
     * workbookFilterCriteria
     */
    private MicrosoftGraphWorkbookFilterCriteria criteria;

    /*
     * workbookFilter
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookFilter class.
     */
    public MicrosoftGraphWorkbookFilter() {
    }

    /**
     * Get the criteria property: workbookFilterCriteria.
     * 
     * @return the criteria value.
     */
    public MicrosoftGraphWorkbookFilterCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set the criteria property: workbookFilterCriteria.
     * 
     * @param criteria the criteria value to set.
     * @return the MicrosoftGraphWorkbookFilter object itself.
     */
    public MicrosoftGraphWorkbookFilter withCriteria(MicrosoftGraphWorkbookFilterCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookFilter.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookFilter.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookFilter object itself.
     */
    public MicrosoftGraphWorkbookFilter withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookFilter withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (criteria() != null) {
            criteria().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("criteria", this.criteria);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookFilter if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookFilter.
     */
    public static MicrosoftGraphWorkbookFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookFilter deserializedMicrosoftGraphWorkbookFilter = new MicrosoftGraphWorkbookFilter();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilter.withId(reader.getString());
                } else if ("criteria".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilter.criteria
                        = MicrosoftGraphWorkbookFilterCriteria.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookFilter.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookFilter;
        });
    }
}
