// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a workbook comment.
 */
@Fluent
public final class MicrosoftGraphWorkbookComment extends MicrosoftGraphEntity {
    /*
     * The content of comment.
     */
    private String content;

    /*
     * Indicates the type for the comment.
     */
    private String contentType;

    /*
     * Read-only. Nullable.
     */
    private List<MicrosoftGraphWorkbookCommentReply> replies;

    /*
     * workbookComment
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookComment class.
     */
    public MicrosoftGraphWorkbookComment() {
    }

    /**
     * Get the content property: The content of comment.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of comment.
     * 
     * @param content the content value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the contentType property: Indicates the type for the comment.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Indicates the type for the comment.
     * 
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the replies property: Read-only. Nullable.
     * 
     * @return the replies value.
     */
    public List<MicrosoftGraphWorkbookCommentReply> replies() {
        return this.replies;
    }

    /**
     * Set the replies property: Read-only. Nullable.
     * 
     * @param replies the replies value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withReplies(List<MicrosoftGraphWorkbookCommentReply> replies) {
        this.replies = replies;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookComment.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookComment.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookComment withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (replies() != null) {
            replies().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeArrayField("replies", this.replies, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookComment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookComment if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookComment.
     */
    public static MicrosoftGraphWorkbookComment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookComment deserializedMicrosoftGraphWorkbookComment
                = new MicrosoftGraphWorkbookComment();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookComment.withId(reader.getString());
                } else if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookComment.content = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookComment.contentType = reader.getString();
                } else if ("replies".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookCommentReply> replies
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookCommentReply.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookComment.replies = replies;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookComment.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookComment;
        });
    }
}
