// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook chart title format.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartTitleFormat extends MicrosoftGraphEntity {
    /*
     * workbookChartFill
     */
    private MicrosoftGraphWorkbookChartFill fill;

    /*
     * workbookChartFont
     */
    private MicrosoftGraphWorkbookChartFont font;

    /*
     * workbookChartTitleFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartTitleFormat class.
     */
    public MicrosoftGraphWorkbookChartTitleFormat() {
    }

    /**
     * Get the fill property: workbookChartFill.
     * 
     * @return the fill value.
     */
    public MicrosoftGraphWorkbookChartFill fill() {
        return this.fill;
    }

    /**
     * Set the fill property: workbookChartFill.
     * 
     * @param fill the fill value to set.
     * @return the MicrosoftGraphWorkbookChartTitleFormat object itself.
     */
    public MicrosoftGraphWorkbookChartTitleFormat withFill(MicrosoftGraphWorkbookChartFill fill) {
        this.fill = fill;
        return this;
    }

    /**
     * Get the font property: workbookChartFont.
     * 
     * @return the font value.
     */
    public MicrosoftGraphWorkbookChartFont font() {
        return this.font;
    }

    /**
     * Set the font property: workbookChartFont.
     * 
     * @param font the font value to set.
     * @return the MicrosoftGraphWorkbookChartTitleFormat object itself.
     */
    public MicrosoftGraphWorkbookChartTitleFormat withFont(MicrosoftGraphWorkbookChartFont font) {
        this.font = font;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartTitleFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartTitleFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartTitleFormat object itself.
     */
    public MicrosoftGraphWorkbookChartTitleFormat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartTitleFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (fill() != null) {
            fill().validate();
        }
        if (font() != null) {
            font().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("fill", this.fill);
        jsonWriter.writeJsonField("font", this.font);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartTitleFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartTitleFormat if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartTitleFormat.
     */
    public static MicrosoftGraphWorkbookChartTitleFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartTitleFormat deserializedMicrosoftGraphWorkbookChartTitleFormat
                = new MicrosoftGraphWorkbookChartTitleFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartTitleFormat.withId(reader.getString());
                } else if ("fill".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartTitleFormat.fill
                        = MicrosoftGraphWorkbookChartFill.fromJson(reader);
                } else if ("font".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartTitleFormat.font
                        = MicrosoftGraphWorkbookChartFont.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartTitleFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartTitleFormat;
        });
    }
}
