// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a workbook chart series.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartSeries extends MicrosoftGraphEntity {
    /*
     * Represents the name of a series in a chart.
     */
    private String name;

    /*
     * workbookChartSeriesFormat
     */
    private MicrosoftGraphWorkbookChartSeriesFormat format;

    /*
     * Represents a collection of all points in the series. Read-only.
     */
    private List<MicrosoftGraphWorkbookChartPoint> points;

    /*
     * workbookChartSeries
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartSeries class.
     */
    public MicrosoftGraphWorkbookChartSeries() {
    }

    /**
     * Get the name property: Represents the name of a series in a chart.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Represents the name of a series in a chart.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the format property: workbookChartSeriesFormat.
     * 
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartSeriesFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartSeriesFormat.
     * 
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withFormat(MicrosoftGraphWorkbookChartSeriesFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the points property: Represents a collection of all points in the series. Read-only.
     * 
     * @return the points value.
     */
    public List<MicrosoftGraphWorkbookChartPoint> points() {
        return this.points;
    }

    /**
     * Set the points property: Represents a collection of all points in the series. Read-only.
     * 
     * @param points the points value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withPoints(List<MicrosoftGraphWorkbookChartPoint> points) {
        this.points = points;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartSeries.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartSeries.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartSeries withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
        if (points() != null) {
            points().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("format", this.format);
        jsonWriter.writeArrayField("points", this.points, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartSeries from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartSeries if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartSeries.
     */
    public static MicrosoftGraphWorkbookChartSeries fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartSeries deserializedMicrosoftGraphWorkbookChartSeries
                = new MicrosoftGraphWorkbookChartSeries();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartSeries.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartSeries.name = reader.getString();
                } else if ("format".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartSeries.format
                        = MicrosoftGraphWorkbookChartSeriesFormat.fromJson(reader);
                } else if ("points".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookChartPoint> points
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookChartPoint.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookChartSeries.points = points;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartSeries.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartSeries;
        });
    }
}
