// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook chart gridlines.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartGridlines extends MicrosoftGraphEntity {
    /*
     * Boolean value representing if the axis gridlines are visible or not.
     */
    private Boolean visible;

    /*
     * workbookChartGridlinesFormat
     */
    private MicrosoftGraphWorkbookChartGridlinesFormat format;

    /*
     * workbookChartGridlines
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartGridlines class.
     */
    public MicrosoftGraphWorkbookChartGridlines() {
    }

    /**
     * Get the visible property: Boolean value representing if the axis gridlines are visible or not.
     * 
     * @return the visible value.
     */
    public Boolean visible() {
        return this.visible;
    }

    /**
     * Set the visible property: Boolean value representing if the axis gridlines are visible or not.
     * 
     * @param visible the visible value to set.
     * @return the MicrosoftGraphWorkbookChartGridlines object itself.
     */
    public MicrosoftGraphWorkbookChartGridlines withVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    /**
     * Get the format property: workbookChartGridlinesFormat.
     * 
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartGridlinesFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartGridlinesFormat.
     * 
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartGridlines object itself.
     */
    public MicrosoftGraphWorkbookChartGridlines withFormat(MicrosoftGraphWorkbookChartGridlinesFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartGridlines.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartGridlines.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartGridlines object itself.
     */
    public MicrosoftGraphWorkbookChartGridlines withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartGridlines withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeBooleanField("visible", this.visible);
        jsonWriter.writeJsonField("format", this.format);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartGridlines from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartGridlines if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartGridlines.
     */
    public static MicrosoftGraphWorkbookChartGridlines fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartGridlines deserializedMicrosoftGraphWorkbookChartGridlines
                = new MicrosoftGraphWorkbookChartGridlines();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartGridlines.withId(reader.getString());
                } else if ("visible".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartGridlines.visible
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("format".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartGridlines.format
                        = MicrosoftGraphWorkbookChartGridlinesFormat.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartGridlines.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartGridlines;
        });
    }
}
