// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook chart axis format.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartAxisFormat extends MicrosoftGraphEntity {
    /*
     * workbookChartFont
     */
    private MicrosoftGraphWorkbookChartFont font;

    /*
     * workbookChartLineFormat
     */
    private MicrosoftGraphWorkbookChartLineFormat line;

    /*
     * workbookChartAxisFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartAxisFormat class.
     */
    public MicrosoftGraphWorkbookChartAxisFormat() {
    }

    /**
     * Get the font property: workbookChartFont.
     * 
     * @return the font value.
     */
    public MicrosoftGraphWorkbookChartFont font() {
        return this.font;
    }

    /**
     * Set the font property: workbookChartFont.
     * 
     * @param font the font value to set.
     * @return the MicrosoftGraphWorkbookChartAxisFormat object itself.
     */
    public MicrosoftGraphWorkbookChartAxisFormat withFont(MicrosoftGraphWorkbookChartFont font) {
        this.font = font;
        return this;
    }

    /**
     * Get the line property: workbookChartLineFormat.
     * 
     * @return the line value.
     */
    public MicrosoftGraphWorkbookChartLineFormat line() {
        return this.line;
    }

    /**
     * Set the line property: workbookChartLineFormat.
     * 
     * @param line the line value to set.
     * @return the MicrosoftGraphWorkbookChartAxisFormat object itself.
     */
    public MicrosoftGraphWorkbookChartAxisFormat withLine(MicrosoftGraphWorkbookChartLineFormat line) {
        this.line = line;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartAxisFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartAxisFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartAxisFormat object itself.
     */
    public MicrosoftGraphWorkbookChartAxisFormat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartAxisFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (font() != null) {
            font().validate();
        }
        if (line() != null) {
            line().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("font", this.font);
        jsonWriter.writeJsonField("line", this.line);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartAxisFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartAxisFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartAxisFormat.
     */
    public static MicrosoftGraphWorkbookChartAxisFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartAxisFormat deserializedMicrosoftGraphWorkbookChartAxisFormat
                = new MicrosoftGraphWorkbookChartAxisFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxisFormat.withId(reader.getString());
                } else if ("font".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxisFormat.font
                        = MicrosoftGraphWorkbookChartFont.fromJson(reader);
                } else if ("line".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxisFormat.line
                        = MicrosoftGraphWorkbookChartLineFormat.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartAxisFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartAxisFormat;
        });
    }
}
