// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a workbook chart axes.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartAxes extends MicrosoftGraphEntity {
    /*
     * workbookChartAxis
     */
    private MicrosoftGraphWorkbookChartAxis categoryAxis;

    /*
     * workbookChartAxis
     */
    private MicrosoftGraphWorkbookChartAxis seriesAxis;

    /*
     * workbookChartAxis
     */
    private MicrosoftGraphWorkbookChartAxis valueAxis;

    /*
     * workbookChartAxes
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartAxes class.
     */
    public MicrosoftGraphWorkbookChartAxes() {
    }

    /**
     * Get the categoryAxis property: workbookChartAxis.
     * 
     * @return the categoryAxis value.
     */
    public MicrosoftGraphWorkbookChartAxis categoryAxis() {
        return this.categoryAxis;
    }

    /**
     * Set the categoryAxis property: workbookChartAxis.
     * 
     * @param categoryAxis the categoryAxis value to set.
     * @return the MicrosoftGraphWorkbookChartAxes object itself.
     */
    public MicrosoftGraphWorkbookChartAxes withCategoryAxis(MicrosoftGraphWorkbookChartAxis categoryAxis) {
        this.categoryAxis = categoryAxis;
        return this;
    }

    /**
     * Get the seriesAxis property: workbookChartAxis.
     * 
     * @return the seriesAxis value.
     */
    public MicrosoftGraphWorkbookChartAxis seriesAxis() {
        return this.seriesAxis;
    }

    /**
     * Set the seriesAxis property: workbookChartAxis.
     * 
     * @param seriesAxis the seriesAxis value to set.
     * @return the MicrosoftGraphWorkbookChartAxes object itself.
     */
    public MicrosoftGraphWorkbookChartAxes withSeriesAxis(MicrosoftGraphWorkbookChartAxis seriesAxis) {
        this.seriesAxis = seriesAxis;
        return this;
    }

    /**
     * Get the valueAxis property: workbookChartAxis.
     * 
     * @return the valueAxis value.
     */
    public MicrosoftGraphWorkbookChartAxis valueAxis() {
        return this.valueAxis;
    }

    /**
     * Set the valueAxis property: workbookChartAxis.
     * 
     * @param valueAxis the valueAxis value to set.
     * @return the MicrosoftGraphWorkbookChartAxes object itself.
     */
    public MicrosoftGraphWorkbookChartAxes withValueAxis(MicrosoftGraphWorkbookChartAxis valueAxis) {
        this.valueAxis = valueAxis;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartAxes.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartAxes.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartAxes object itself.
     */
    public MicrosoftGraphWorkbookChartAxes withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartAxes withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (categoryAxis() != null) {
            categoryAxis().validate();
        }
        if (seriesAxis() != null) {
            seriesAxis().validate();
        }
        if (valueAxis() != null) {
            valueAxis().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("categoryAxis", this.categoryAxis);
        jsonWriter.writeJsonField("seriesAxis", this.seriesAxis);
        jsonWriter.writeJsonField("valueAxis", this.valueAxis);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartAxes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartAxes if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartAxes.
     */
    public static MicrosoftGraphWorkbookChartAxes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartAxes deserializedMicrosoftGraphWorkbookChartAxes
                = new MicrosoftGraphWorkbookChartAxes();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxes.withId(reader.getString());
                } else if ("categoryAxis".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxes.categoryAxis
                        = MicrosoftGraphWorkbookChartAxis.fromJson(reader);
                } else if ("seriesAxis".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxes.seriesAxis
                        = MicrosoftGraphWorkbookChartAxis.fromJson(reader);
                } else if ("valueAxis".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxes.valueAxis
                        = MicrosoftGraphWorkbookChartAxis.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartAxes.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartAxes;
        });
    }
}
