// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents a wellknown list name.
 */
public final class MicrosoftGraphWellknownListName extends ExpandableStringEnum<MicrosoftGraphWellknownListName> {
    /**
     * Static value none for MicrosoftGraphWellknownListName.
     */
    public static final MicrosoftGraphWellknownListName NONE = fromString("none");

    /**
     * Static value defaultList for MicrosoftGraphWellknownListName.
     */
    public static final MicrosoftGraphWellknownListName DEFAULT_LIST = fromString("defaultList");

    /**
     * Static value flaggedEmails for MicrosoftGraphWellknownListName.
     */
    public static final MicrosoftGraphWellknownListName FLAGGED_EMAILS = fromString("flaggedEmails");

    /**
     * Static value unknownFutureValue for MicrosoftGraphWellknownListName.
     */
    public static final MicrosoftGraphWellknownListName UNKNOWN_FUTURE_VALUE = fromString("unknownFutureValue");

    /**
     * Creates a new instance of MicrosoftGraphWellknownListName value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MicrosoftGraphWellknownListName() {
    }

    /**
     * Creates or finds a MicrosoftGraphWellknownListName from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MicrosoftGraphWellknownListName.
     */
    public static MicrosoftGraphWellknownListName fromString(String name) {
        return fromString(name, MicrosoftGraphWellknownListName.class);
    }

    /**
     * Gets known MicrosoftGraphWellknownListName values.
     * 
     * @return known MicrosoftGraphWellknownListName values.
     */
    public static Collection<MicrosoftGraphWellknownListName> values() {
        return values(MicrosoftGraphWellknownListName.class);
    }
}
