// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a verified domain.
 */
@Fluent
public final class MicrosoftGraphVerifiedDomain implements JsonSerializable<MicrosoftGraphVerifiedDomain> {
    /*
     * For example, 'Email', 'OfficeCommunicationsOnline'.
     */
    private String capabilities;

    /*
     * true if this is the default domain associated with the tenant; otherwise, false.
     */
    private Boolean isDefault;

    /*
     * true if this is the initial domain associated with the tenant; otherwise, false
     */
    private Boolean isInitial;

    /*
     * The domain name; for example, 'contoso.onmicrosoft.com'
     */
    private String name;

    /*
     * For example, 'Managed'.
     */
    private String type;

    /*
     * verifiedDomain
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphVerifiedDomain class.
     */
    public MicrosoftGraphVerifiedDomain() {
    }

    /**
     * Get the capabilities property: For example, 'Email', 'OfficeCommunicationsOnline'.
     * 
     * @return the capabilities value.
     */
    public String capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: For example, 'Email', 'OfficeCommunicationsOnline'.
     * 
     * @param capabilities the capabilities value to set.
     * @return the MicrosoftGraphVerifiedDomain object itself.
     */
    public MicrosoftGraphVerifiedDomain withCapabilities(String capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the isDefault property: true if this is the default domain associated with the tenant; otherwise, false.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: true if this is the default domain associated with the tenant; otherwise, false.
     * 
     * @param isDefault the isDefault value to set.
     * @return the MicrosoftGraphVerifiedDomain object itself.
     */
    public MicrosoftGraphVerifiedDomain withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isInitial property: true if this is the initial domain associated with the tenant; otherwise, false.
     * 
     * @return the isInitial value.
     */
    public Boolean isInitial() {
        return this.isInitial;
    }

    /**
     * Set the isInitial property: true if this is the initial domain associated with the tenant; otherwise, false.
     * 
     * @param isInitial the isInitial value to set.
     * @return the MicrosoftGraphVerifiedDomain object itself.
     */
    public MicrosoftGraphVerifiedDomain withIsInitial(Boolean isInitial) {
        this.isInitial = isInitial;
        return this;
    }

    /**
     * Get the name property: The domain name; for example, 'contoso.onmicrosoft.com'.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The domain name; for example, 'contoso.onmicrosoft.com'.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphVerifiedDomain object itself.
     */
    public MicrosoftGraphVerifiedDomain withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: For example, 'Managed'.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: For example, 'Managed'.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphVerifiedDomain object itself.
     */
    public MicrosoftGraphVerifiedDomain withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: verifiedDomain.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: verifiedDomain.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphVerifiedDomain object itself.
     */
    public MicrosoftGraphVerifiedDomain withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("capabilities", this.capabilities);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isInitial", this.isInitial);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphVerifiedDomain from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphVerifiedDomain if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphVerifiedDomain.
     */
    public static MicrosoftGraphVerifiedDomain fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphVerifiedDomain deserializedMicrosoftGraphVerifiedDomain = new MicrosoftGraphVerifiedDomain();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capabilities".equals(fieldName)) {
                    deserializedMicrosoftGraphVerifiedDomain.capabilities = reader.getString();
                } else if ("isDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphVerifiedDomain.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("isInitial".equals(fieldName)) {
                    deserializedMicrosoftGraphVerifiedDomain.isInitial = reader.getNullable(JsonReader::getBoolean);
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphVerifiedDomain.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphVerifiedDomain.type = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphVerifiedDomain.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphVerifiedDomain;
        });
    }
}
