// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an user settings.
 */
@Fluent
public final class MicrosoftGraphUserSettings extends MicrosoftGraphEntity {
    /*
     * The contributionToContentDiscoveryAsOrganizationDisabled property.
     */
    private Boolean contributionToContentDiscoveryAsOrganizationDisabled;

    /*
     * The contributionToContentDiscoveryDisabled property.
     */
    private Boolean contributionToContentDiscoveryDisabled;

    /*
     * shiftPreferences
     */
    private MicrosoftGraphShiftPreferences shiftPreferences;

    /*
     * userSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphUserSettings class.
     */
    public MicrosoftGraphUserSettings() {
    }

    /**
     * Get the contributionToContentDiscoveryAsOrganizationDisabled property: The
     * contributionToContentDiscoveryAsOrganizationDisabled property.
     * 
     * @return the contributionToContentDiscoveryAsOrganizationDisabled value.
     */
    public Boolean contributionToContentDiscoveryAsOrganizationDisabled() {
        return this.contributionToContentDiscoveryAsOrganizationDisabled;
    }

    /**
     * Set the contributionToContentDiscoveryAsOrganizationDisabled property: The
     * contributionToContentDiscoveryAsOrganizationDisabled property.
     * 
     * @param contributionToContentDiscoveryAsOrganizationDisabled the
     * contributionToContentDiscoveryAsOrganizationDisabled value to set.
     * @return the MicrosoftGraphUserSettings object itself.
     */
    public MicrosoftGraphUserSettings withContributionToContentDiscoveryAsOrganizationDisabled(
        Boolean contributionToContentDiscoveryAsOrganizationDisabled) {
        this.contributionToContentDiscoveryAsOrganizationDisabled
            = contributionToContentDiscoveryAsOrganizationDisabled;
        return this;
    }

    /**
     * Get the contributionToContentDiscoveryDisabled property: The contributionToContentDiscoveryDisabled property.
     * 
     * @return the contributionToContentDiscoveryDisabled value.
     */
    public Boolean contributionToContentDiscoveryDisabled() {
        return this.contributionToContentDiscoveryDisabled;
    }

    /**
     * Set the contributionToContentDiscoveryDisabled property: The contributionToContentDiscoveryDisabled property.
     * 
     * @param contributionToContentDiscoveryDisabled the contributionToContentDiscoveryDisabled value to set.
     * @return the MicrosoftGraphUserSettings object itself.
     */
    public MicrosoftGraphUserSettings
        withContributionToContentDiscoveryDisabled(Boolean contributionToContentDiscoveryDisabled) {
        this.contributionToContentDiscoveryDisabled = contributionToContentDiscoveryDisabled;
        return this;
    }

    /**
     * Get the shiftPreferences property: shiftPreferences.
     * 
     * @return the shiftPreferences value.
     */
    public MicrosoftGraphShiftPreferences shiftPreferences() {
        return this.shiftPreferences;
    }

    /**
     * Set the shiftPreferences property: shiftPreferences.
     * 
     * @param shiftPreferences the shiftPreferences value to set.
     * @return the MicrosoftGraphUserSettings object itself.
     */
    public MicrosoftGraphUserSettings withShiftPreferences(MicrosoftGraphShiftPreferences shiftPreferences) {
        this.shiftPreferences = shiftPreferences;
        return this;
    }

    /**
     * Get the additionalProperties property: userSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: userSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphUserSettings object itself.
     */
    public MicrosoftGraphUserSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphUserSettings withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (shiftPreferences() != null) {
            shiftPreferences().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeBooleanField("contributionToContentDiscoveryAsOrganizationDisabled",
            this.contributionToContentDiscoveryAsOrganizationDisabled);
        jsonWriter.writeBooleanField("contributionToContentDiscoveryDisabled",
            this.contributionToContentDiscoveryDisabled);
        jsonWriter.writeJsonField("shiftPreferences", this.shiftPreferences);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphUserSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphUserSettings if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphUserSettings.
     */
    public static MicrosoftGraphUserSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphUserSettings deserializedMicrosoftGraphUserSettings = new MicrosoftGraphUserSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphUserSettings.withId(reader.getString());
                } else if ("contributionToContentDiscoveryAsOrganizationDisabled".equals(fieldName)) {
                    deserializedMicrosoftGraphUserSettings.contributionToContentDiscoveryAsOrganizationDisabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("contributionToContentDiscoveryDisabled".equals(fieldName)) {
                    deserializedMicrosoftGraphUserSettings.contributionToContentDiscoveryDisabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("shiftPreferences".equals(fieldName)) {
                    deserializedMicrosoftGraphUserSettings.shiftPreferences
                        = MicrosoftGraphShiftPreferences.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphUserSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphUserSettings;
        });
    }
}
