// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents an user activity.
 */
@Fluent
public final class MicrosoftGraphUserActivity extends MicrosoftGraphEntity {
    /*
     * Required. URL used to launch the activity in the best native experience represented by the appId. Might launch a
     * web-based app if no native app exists.
     */
    private String activationUrl;

    /*
     * The activitySourceHost property.
     */
    private String activitySourceHost;

    /*
     * Required. The unique activity ID in the context of the app - supplied by caller and immutable thereafter.
     */
    private String appActivityId;

    /*
     * Optional. Short text description of the app used to generate the activity for use in cases when the app is not
     * installed on the user’s local device.
     */
    private String appDisplayName;

    /*
     * Json
     */
    private Map<String, Object> contentInfo;

    /*
     * Optional. Used in the event the content can be rendered outside of a native or web-based app experience (for
     * example, a pointer to an item in an RSS feed).
     */
    private String contentUrl;

    /*
     * Set by the server. DateTime in UTC when the object was created on the server.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Set by the server. DateTime in UTC when the object expired on the server.
     */
    private OffsetDateTime expirationDateTime;

    /*
     * Optional. URL used to launch the activity in a web-based app, if available.
     */
    private String fallbackUrl;

    /*
     * Set by the server. DateTime in UTC when the object was modified on the server.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * status
     */
    private MicrosoftGraphStatus status;

    /*
     * Optional. The timezone in which the user's device used to generate the activity was located at activity creation
     * time; values supplied as Olson IDs in order to support cross-platform representation.
     */
    private String userTimezone;

    /*
     * visualInfo
     */
    private MicrosoftGraphVisualInfo visualElements;

    /*
     * Optional. NavigationProperty/Containment; navigation property to the activity's historyItems.
     */
    private List<MicrosoftGraphActivityHistoryItem> historyItems;

    /*
     * userActivity
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphUserActivity class.
     */
    public MicrosoftGraphUserActivity() {
    }

    /**
     * Get the activationUrl property: Required. URL used to launch the activity in the best native experience
     * represented by the appId. Might launch a web-based app if no native app exists.
     * 
     * @return the activationUrl value.
     */
    public String activationUrl() {
        return this.activationUrl;
    }

    /**
     * Set the activationUrl property: Required. URL used to launch the activity in the best native experience
     * represented by the appId. Might launch a web-based app if no native app exists.
     * 
     * @param activationUrl the activationUrl value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
        return this;
    }

    /**
     * Get the activitySourceHost property: The activitySourceHost property.
     * 
     * @return the activitySourceHost value.
     */
    public String activitySourceHost() {
        return this.activitySourceHost;
    }

    /**
     * Set the activitySourceHost property: The activitySourceHost property.
     * 
     * @param activitySourceHost the activitySourceHost value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withActivitySourceHost(String activitySourceHost) {
        this.activitySourceHost = activitySourceHost;
        return this;
    }

    /**
     * Get the appActivityId property: Required. The unique activity ID in the context of the app - supplied by caller
     * and immutable thereafter.
     * 
     * @return the appActivityId value.
     */
    public String appActivityId() {
        return this.appActivityId;
    }

    /**
     * Set the appActivityId property: Required. The unique activity ID in the context of the app - supplied by caller
     * and immutable thereafter.
     * 
     * @param appActivityId the appActivityId value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withAppActivityId(String appActivityId) {
        this.appActivityId = appActivityId;
        return this;
    }

    /**
     * Get the appDisplayName property: Optional. Short text description of the app used to generate the activity for
     * use in cases when the app is not installed on the user’s local device.
     * 
     * @return the appDisplayName value.
     */
    public String appDisplayName() {
        return this.appDisplayName;
    }

    /**
     * Set the appDisplayName property: Optional. Short text description of the app used to generate the activity for
     * use in cases when the app is not installed on the user’s local device.
     * 
     * @param appDisplayName the appDisplayName value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withAppDisplayName(String appDisplayName) {
        this.appDisplayName = appDisplayName;
        return this;
    }

    /**
     * Get the contentInfo property: Json.
     * 
     * @return the contentInfo value.
     */
    public Map<String, Object> contentInfo() {
        return this.contentInfo;
    }

    /**
     * Set the contentInfo property: Json.
     * 
     * @param contentInfo the contentInfo value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withContentInfo(Map<String, Object> contentInfo) {
        this.contentInfo = contentInfo;
        return this;
    }

    /**
     * Get the contentUrl property: Optional. Used in the event the content can be rendered outside of a native or
     * web-based app experience (for example, a pointer to an item in an RSS feed).
     * 
     * @return the contentUrl value.
     */
    public String contentUrl() {
        return this.contentUrl;
    }

    /**
     * Set the contentUrl property: Optional. Used in the event the content can be rendered outside of a native or
     * web-based app experience (for example, a pointer to an item in an RSS feed).
     * 
     * @param contentUrl the contentUrl value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    /**
     * Get the createdDateTime property: Set by the server. DateTime in UTC when the object was created on the server.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Set by the server. DateTime in UTC when the object was created on the server.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the expirationDateTime property: Set by the server. DateTime in UTC when the object expired on the server.
     * 
     * @return the expirationDateTime value.
     */
    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Set the expirationDateTime property: Set by the server. DateTime in UTC when the object expired on the server.
     * 
     * @param expirationDateTime the expirationDateTime value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    /**
     * Get the fallbackUrl property: Optional. URL used to launch the activity in a web-based app, if available.
     * 
     * @return the fallbackUrl value.
     */
    public String fallbackUrl() {
        return this.fallbackUrl;
    }

    /**
     * Set the fallbackUrl property: Optional. URL used to launch the activity in a web-based app, if available.
     * 
     * @param fallbackUrl the fallbackUrl value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withFallbackUrl(String fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: Set by the server. DateTime in UTC when the object was modified on the
     * server.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: Set by the server. DateTime in UTC when the object was modified on the
     * server.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the status property: status.
     * 
     * @return the status value.
     */
    public MicrosoftGraphStatus status() {
        return this.status;
    }

    /**
     * Set the status property: status.
     * 
     * @param status the status value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withStatus(MicrosoftGraphStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the userTimezone property: Optional. The timezone in which the user's device used to generate the activity
     * was located at activity creation time; values supplied as Olson IDs in order to support cross-platform
     * representation.
     * 
     * @return the userTimezone value.
     */
    public String userTimezone() {
        return this.userTimezone;
    }

    /**
     * Set the userTimezone property: Optional. The timezone in which the user's device used to generate the activity
     * was located at activity creation time; values supplied as Olson IDs in order to support cross-platform
     * representation.
     * 
     * @param userTimezone the userTimezone value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
        return this;
    }

    /**
     * Get the visualElements property: visualInfo.
     * 
     * @return the visualElements value.
     */
    public MicrosoftGraphVisualInfo visualElements() {
        return this.visualElements;
    }

    /**
     * Set the visualElements property: visualInfo.
     * 
     * @param visualElements the visualElements value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withVisualElements(MicrosoftGraphVisualInfo visualElements) {
        this.visualElements = visualElements;
        return this;
    }

    /**
     * Get the historyItems property: Optional. NavigationProperty/Containment; navigation property to the activity's
     * historyItems.
     * 
     * @return the historyItems value.
     */
    public List<MicrosoftGraphActivityHistoryItem> historyItems() {
        return this.historyItems;
    }

    /**
     * Set the historyItems property: Optional. NavigationProperty/Containment; navigation property to the activity's
     * historyItems.
     * 
     * @param historyItems the historyItems value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withHistoryItems(List<MicrosoftGraphActivityHistoryItem> historyItems) {
        this.historyItems = historyItems;
        return this;
    }

    /**
     * Get the additionalProperties property: userActivity.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: userActivity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphUserActivity object itself.
     */
    public MicrosoftGraphUserActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphUserActivity withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (visualElements() != null) {
            visualElements().validate();
        }
        if (historyItems() != null) {
            historyItems().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("activationUrl", this.activationUrl);
        jsonWriter.writeStringField("activitySourceHost", this.activitySourceHost);
        jsonWriter.writeStringField("appActivityId", this.appActivityId);
        jsonWriter.writeStringField("appDisplayName", this.appDisplayName);
        jsonWriter.writeMapField("contentInfo", this.contentInfo, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("contentUrl", this.contentUrl);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("expirationDateTime",
            this.expirationDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("fallbackUrl", this.fallbackUrl);
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("userTimezone", this.userTimezone);
        jsonWriter.writeJsonField("visualElements", this.visualElements);
        jsonWriter.writeArrayField("historyItems", this.historyItems, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphUserActivity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphUserActivity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphUserActivity.
     */
    public static MicrosoftGraphUserActivity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphUserActivity deserializedMicrosoftGraphUserActivity = new MicrosoftGraphUserActivity();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.withId(reader.getString());
                } else if ("activationUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.activationUrl = reader.getString();
                } else if ("activitySourceHost".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.activitySourceHost = reader.getString();
                } else if ("appActivityId".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.appActivityId = reader.getString();
                } else if ("appDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.appDisplayName = reader.getString();
                } else if ("contentInfo".equals(fieldName)) {
                    Map<String, Object> contentInfo = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphUserActivity.contentInfo = contentInfo;
                } else if ("contentUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.contentUrl = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.expirationDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("fallbackUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.fallbackUrl = reader.getString();
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.status = MicrosoftGraphStatus.fromString(reader.getString());
                } else if ("userTimezone".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.userTimezone = reader.getString();
                } else if ("visualElements".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.visualElements = MicrosoftGraphVisualInfo.fromJson(reader);
                } else if ("historyItems".equals(fieldName)) {
                    List<MicrosoftGraphActivityHistoryItem> historyItems
                        = reader.readArray(reader1 -> MicrosoftGraphActivityHistoryItem.fromJson(reader1));
                    deserializedMicrosoftGraphUserActivity.historyItems = historyItems;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphUserActivity.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphUserActivity;
        });
    }
}
