// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an usage details.
 */
@Fluent
public final class MicrosoftGraphUsageDetails implements JsonSerializable<MicrosoftGraphUsageDetails> {
    /*
     * The date and time the resource was last accessed by the user. The timestamp represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * 2014-01-01T00:00:00Z. Read-only.
     */
    private OffsetDateTime lastAccessedDateTime;

    /*
     * The date and time the resource was last modified by the user. The timestamp represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * 2014-01-01T00:00:00Z. Read-only.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * usageDetails
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphUsageDetails class.
     */
    public MicrosoftGraphUsageDetails() {
    }

    /**
     * Get the lastAccessedDateTime property: The date and time the resource was last accessed by the user. The
     * timestamp represents date and time information using ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this: 2014-01-01T00:00:00Z. Read-only.
     * 
     * @return the lastAccessedDateTime value.
     */
    public OffsetDateTime lastAccessedDateTime() {
        return this.lastAccessedDateTime;
    }

    /**
     * Set the lastAccessedDateTime property: The date and time the resource was last accessed by the user. The
     * timestamp represents date and time information using ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this: 2014-01-01T00:00:00Z. Read-only.
     * 
     * @param lastAccessedDateTime the lastAccessedDateTime value to set.
     * @return the MicrosoftGraphUsageDetails object itself.
     */
    public MicrosoftGraphUsageDetails withLastAccessedDateTime(OffsetDateTime lastAccessedDateTime) {
        this.lastAccessedDateTime = lastAccessedDateTime;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: The date and time the resource was last modified by the user. The
     * timestamp represents date and time information using ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this: 2014-01-01T00:00:00Z. Read-only.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: The date and time the resource was last modified by the user. The
     * timestamp represents date and time information using ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this: 2014-01-01T00:00:00Z. Read-only.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphUsageDetails object itself.
     */
    public MicrosoftGraphUsageDetails withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: usageDetails.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: usageDetails.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphUsageDetails object itself.
     */
    public MicrosoftGraphUsageDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastAccessedDateTime",
            this.lastAccessedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastAccessedDateTime));
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphUsageDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphUsageDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphUsageDetails.
     */
    public static MicrosoftGraphUsageDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphUsageDetails deserializedMicrosoftGraphUsageDetails = new MicrosoftGraphUsageDetails();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lastAccessedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUsageDetails.lastAccessedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUsageDetails.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphUsageDetails.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphUsageDetails;
        });
    }
}
