// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a time slot.
 */
@Fluent
public final class MicrosoftGraphTimeSlot implements JsonSerializable<MicrosoftGraphTimeSlot> {
    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone end;

    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone start;

    /*
     * timeSlot
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTimeSlot class.
     */
    public MicrosoftGraphTimeSlot() {
    }

    /**
     * Get the end property: dateTimeTimeZone.
     * 
     * @return the end value.
     */
    public MicrosoftGraphDateTimeZone end() {
        return this.end;
    }

    /**
     * Set the end property: dateTimeTimeZone.
     * 
     * @param end the end value to set.
     * @return the MicrosoftGraphTimeSlot object itself.
     */
    public MicrosoftGraphTimeSlot withEnd(MicrosoftGraphDateTimeZone end) {
        this.end = end;
        return this;
    }

    /**
     * Get the start property: dateTimeTimeZone.
     * 
     * @return the start value.
     */
    public MicrosoftGraphDateTimeZone start() {
        return this.start;
    }

    /**
     * Set the start property: dateTimeTimeZone.
     * 
     * @param start the start value to set.
     * @return the MicrosoftGraphTimeSlot object itself.
     */
    public MicrosoftGraphTimeSlot withStart(MicrosoftGraphDateTimeZone start) {
        this.start = start;
        return this;
    }

    /**
     * Get the additionalProperties property: timeSlot.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeSlot.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeSlot object itself.
     */
    public MicrosoftGraphTimeSlot withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (end() != null) {
            end().validate();
        }
        if (start() != null) {
            start().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("end", this.end);
        jsonWriter.writeJsonField("start", this.start);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTimeSlot from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTimeSlot if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTimeSlot.
     */
    public static MicrosoftGraphTimeSlot fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTimeSlot deserializedMicrosoftGraphTimeSlot = new MicrosoftGraphTimeSlot();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("end".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeSlot.end = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("start".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeSlot.start = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTimeSlot.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTimeSlot;
        });
    }
}
